/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.ui.internal.team.history;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfo;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoHandler;
import org.eclipse.emf.cdo.common.commit.CDOCommitInfoManager;
import org.eclipse.emf.cdo.eresource.CDOResourceFolder;
import org.eclipse.emf.cdo.internal.ui.history.Net;
import org.eclipse.emf.cdo.internal.ui.history.NetRenderer;
import org.eclipse.emf.cdo.internal.ui.history.Track;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.transaction.CDOTransaction;
import org.eclipse.emf.cdo.transaction.CDOTransactionCommentator;
import org.eclipse.emf.cdo.transaction.CDOTransactionOpener;
import org.eclipse.emf.cdo.ui.compare.CDOCompareEditorUtil;
import org.eclipse.emf.cdo.ui.internal.team.bundle.OM;
import org.eclipse.emf.cdo.ui.internal.team.history.DropConfirmationDialog;
import org.eclipse.emf.cdo.ui.widgets.CommitHistoryComposite;
import org.eclipse.emf.cdo.util.CDOUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewOpener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleEventAdapter;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.widgets.StackComposite;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;

public class CDOHistoryPage
extends HistoryPage {
    private static final String POPUP_ID = "#PopupMenu";
    private static final boolean DEBUG = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.ui.team.history.debug");
    private static final boolean TEST = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.ui.team.history.test");
    private StackComposite stackComposite;
    private Control offlineControl;
    private CommitHistoryComposite commitHistoryComposite;
    private CommitHistoryComposite.Input input;
    private IListener inputListener = new LifecycleEventAdapter(){

        protected void onDeactivated(ILifecycle lifecycle) {
            if (!CDOHistoryPage.this.commitHistoryComposite.isDisposed()) {
                CDOHistoryPage.this.commitHistoryComposite.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(this).CDOHistoryPage.this.commitHistoryComposite.isDisposed()) {
                            CDOHistoryPage.this.setInput(null);
                        }
                    }
                });
            }
        }
    };

    public String getName() {
        return this.input != null ? this.input.toString() : null;
    }

    public String getDescription() {
        return "";
    }

    public Control getControl() {
        return this.stackComposite;
    }

    public void createControl(Composite parent) {
        this.stackComposite = new StackComposite(parent, 0);
        Label label = new Label((Composite)this.stackComposite, 0);
        label.setText("The selected session belongs to an offline workspace.\nThe remote history cannot be provided.");
        label.setForeground(label.getDisplay().getSystemColor(10));
        this.offlineControl = label;
        this.commitHistoryComposite = new CommitHistoryComposite((Composite)this.stackComposite, 0){

            protected void doubleClicked(CDOCommitInfo commitInfo) {
                if (TEST) {
                    new TransactionalBranchPointOperation(CDOHistoryPage.this){

                        @Override
                        protected void run(CDOTransaction transaction) {
                            CDOResourceFolder folder = transaction.getOrCreateResourceFolder("test");
                            folder.addResource("resource-" + folder.getNodes().size());
                        }
                    }.execute((CDOBranchPoint)commitInfo);
                }
            }
        };
        this.stackComposite.setTopControl((Control)this.commitHistoryComposite);
        IPageSite site = this.getSite();
        TableViewer tableViewer = this.commitHistoryComposite.getTableViewer();
        UIUtil.addDragSupport((StructuredViewer)tableViewer);
        tableViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)tableViewer){
            {
                this.setFeedbackEnabled(false);
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target instanceof CDOCommitInfo && LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    CDOCommitInfo commitInfo = (CDOCommitInfo)target;
                    CDOBranch branch = commitInfo.getBranch();
                    CDOCommitInfoManager commitInfoManager = commitInfo.getCommitInfoManager();
                    long lastCommitOfBranch = commitInfoManager.getLastCommitOfBranch(branch, true);
                    if (commitInfo.getTimeStamp() == lastCommitOfBranch) {
                        return true;
                    }
                }
                return false;
            }

            public boolean performDrop(Object data) {
                final CDOCommitInfo sourcePoint = (CDOCommitInfo)UIUtil.getElement((ISelection)((ISelection)data), CDOCommitInfo.class);
                final CDOBranch targetBranch = ((CDOCommitInfo)this.getCurrentTarget()).getBranch();
                final Shell shell = CDOHistoryPage.this.stackComposite.getShell();
                DropConfirmationDialog dialog = new DropConfirmationDialog(shell, (CDOBranchPoint)sourcePoint, targetBranch);
                if (dialog.open() != 0) {
                    return false;
                }
                DropConfirmationDialog.Operation operation = dialog.getOperation();
                final String label = StringUtil.capAll((String)operation.getLabel());
                final CDOSession session = CDOUtil.getSession((Object)targetBranch);
                if (operation == DropConfirmationDialog.Operation.MERGE_FROM) {
                    CDOCompareEditorUtil.openEditor((CDOViewOpener)session, (CDOTransactionOpener)session, (CDOBranchPoint)sourcePoint, (CDOBranchPoint)targetBranch.getHead(), null, (boolean)true);
                } else {
                    new Job(label){

                        protected IStatus run(IProgressMonitor progressMonitor) {
                            try (CDOTransaction transaction = null;){
                                try {
                                    transaction = session.openTransaction(targetBranch);
                                    CDOUtil.configureView((CDOView)transaction);
                                    transaction.revertTo((CDOBranchPoint)sourcePoint);
                                    CDOTransactionCommentator.setRevertComment((CDOTransaction)transaction, (CDOBranchPoint)sourcePoint);
                                    transaction.commit(progressMonitor);
                                }
                                catch (Exception ex) {
                                    OM.LOG.error((Throwable)ex);
                                    String message = ex.getMessage();
                                    Status status = new Status(4, "org.eclipse.emf.cdo.ui.team", message, (Throwable)ex);
                                    UIUtil.asyncExec(() -> {
                                        int n = ErrorDialog.openError((Shell)shell, (String)label, (String)message, (IStatus)status);
                                    });
                                    transaction.close();
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
                return true;
            }
        });
        if (DEBUG) {
            ((CommitHistoryComposite.LabelProvider)tableViewer.getLabelProvider()).setFormatTimeStamps(false);
        }
        MenuManager menuManager = new MenuManager(POPUP_ID);
        menuManager.add((IContributionItem)new Separator("compare"));
        menuManager.add((IContributionItem)new Separator("branching"));
        menuManager.add((IContributionItem)new Separator("additions"));
        Menu menu = menuManager.createContextMenu(tableViewer.getControl());
        tableViewer.getControl().setMenu(menu);
        site.registerContextMenu(POPUP_ID, menuManager, (ISelectionProvider)tableViewer);
        site.setSelectionProvider((ISelectionProvider)tableViewer);
        IActionBars actionBars = site.getActionBars();
        this.setupToolBar(actionBars.getToolBarManager());
        this.setupViewMenu(actionBars.getMenuManager());
    }

    public void setFocus() {
        this.commitHistoryComposite.setFocus();
    }

    public void refresh() {
        this.commitHistoryComposite.refreshLayout(true);
    }

    public Object getAdapter(Class adapter) {
        return AdapterUtil.adapt((Object)((Object)this), (Class)adapter, (boolean)false);
    }

    public boolean isValidInput(Object object) {
        return CDOHistoryPage.canShowHistoryFor(object);
    }

    public boolean inputSet() {
        if (this.input != null) {
            this.input.removeListener(this.inputListener);
            this.input.deactivate();
            this.input = null;
        }
        Object object = this.getInput();
        try {
            this.input = new CommitHistoryComposite.Input(object);
            this.input.addListener(this.inputListener);
            this.input.activate();
            if (this.input.isOffline()) {
                this.stackComposite.setTopControl(this.offlineControl);
            } else {
                this.stackComposite.setTopControl((Control)this.commitHistoryComposite);
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
        finally {
            this.commitHistoryComposite.setInput(this.input);
        }
    }

    public void dispose() {
        if (this.input != null) {
            this.input.deactivate();
            this.input = null;
        }
        super.dispose();
    }

    protected void setupToolBar(IToolBarManager manager) {
        if (DEBUG) {
            Action action = new Action("DEBUG", 1){

                public void run() {
                    NetRenderer netRenderer = (NetRenderer)ReflectUtil.getValue((Field)ReflectUtil.getField(CommitHistoryComposite.class, (String)"netRenderer"), (Object)CDOHistoryPage.this.commitHistoryComposite);
                    Net net = netRenderer.getNet();
                    Track[] tracks = net.getTracks();
                    CDOSession session = net.getSession();
                    System.out.println("Debug " + net);
                }
            };
            ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
            action.setImageDescriptor(sharedImages.getImageDescriptor("IMG_OBJS_INFO_TSK"));
            manager.add((IAction)action);
        }
    }

    protected void setupViewMenu(IMenuManager manager) {
        manager.add((IAction)new TableRedrawingAction(this, "Format Time Stamps", 32){

            @Override
            protected boolean getInitialCheckState(CommitHistoryComposite.LabelProvider labelProvider) {
                return labelProvider.isFormatTimeStamps();
            }

            @Override
            protected void doRun(CommitHistoryComposite.LabelProvider labelProvider) {
                labelProvider.setFormatTimeStamps(!labelProvider.isFormatTimeStamps());
            }
        });
        manager.add((IAction)new TableRedrawingAction(this, "Shorten Branch Paths", 32){

            @Override
            protected boolean getInitialCheckState(CommitHistoryComposite.LabelProvider labelProvider) {
                return labelProvider.isShortenBranchPaths();
            }

            @Override
            protected void doRun(CommitHistoryComposite.LabelProvider labelProvider) {
                labelProvider.setShortenBranchPaths(!labelProvider.isShortenBranchPaths());
            }
        });
    }

    public static boolean canShowHistoryFor(Object object) {
        if (object == null) {
            return false;
        }
        try {
            new CommitHistoryComposite.Input(object);
            return true;
        }
        catch (CommitHistoryComposite.Input.IllegalInputException ex) {
            return false;
        }
    }

    private abstract class TableRedrawingAction
    extends Action {
        private final CommitHistoryComposite.LabelProvider labelProvider;

        public TableRedrawingAction(String text, int style) {
            super(text, style);
            this.labelProvider = CDOHistoryPage.this.commitHistoryComposite.getLabelProvider();
            this.setChecked(this.getInitialCheckState(this.labelProvider));
        }

        public void run() {
            this.doRun(this.labelProvider);
            CDOHistoryPage.this.commitHistoryComposite.getTableViewer().getTable().redraw();
        }

        protected abstract void doRun(CommitHistoryComposite.LabelProvider var1);

        protected abstract boolean getInitialCheckState(CommitHistoryComposite.LabelProvider var1);
    }

    private abstract class TransactionalBranchPointOperation {
        private TransactionalBranchPointOperation() {
        }

        /*
         * Loose catch block
         */
        public boolean execute(CDOBranchPoint branchPoint) {
            block8: {
                CDOTransaction transaction = null;
                CDOSession session = CDOHistoryPage.this.input.getSession();
                CDOBranch branch = branchPoint.getBranch();
                final long[] lastCommitTime = new long[1];
                CDOCommitInfoManager commitInfoManager = session.getCommitInfoManager();
                commitInfoManager.getCommitInfos(branch, Long.MAX_VALUE, null, null, -1, new CDOCommitInfoHandler(){

                    public void handleCommitInfo(CDOCommitInfo commitInfo) {
                        lastCommitTime[0] = commitInfo.getTimeStamp();
                    }
                });
                long timeStamp = branchPoint.getTimeStamp();
                if (timeStamp != lastCommitTime[0]) {
                    String name = "branch" + (timeStamp - session.getRepositoryInfo().getCreationTime()) / 1000L;
                    branch = branch.createBranch(name, timeStamp);
                }
                transaction = session.openTransaction(branch);
                CDOUtil.configureView((CDOView)transaction);
                this.run(transaction);
                transaction.commit();
                LifecycleUtil.deactivate((Object)transaction);
                return true;
                {
                    catch (Throwable ex) {
                        try {
                            try {
                                ex.printStackTrace();
                            }
                            catch (Exception ex2) {
                                ex2.printStackTrace();
                                LifecycleUtil.deactivate(transaction);
                                break block8;
                            }
                        }
                        catch (Throwable throwable) {
                            LifecycleUtil.deactivate(transaction);
                            throw throwable;
                        }
                    }
                }
                LifecycleUtil.deactivate((Object)transaction);
            }
            return false;
        }

        protected abstract void run(CDOTransaction var1) throws Exception;
    }
}

