/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jst.pagedesigner.PDPlugin;
import org.eclipse.jst.pagedesigner.editors.HTMLEditor;
import org.eclipse.jst.pagedesigner.properties.DesignerPropertyTool;
import org.eclipse.jst.pagedesigner.properties.NavigationHiearchyAction;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.w3c.dom.Node;

public class WPETabbedPropertySheetPage
extends TabbedPropertySheetPage {
    private HTMLEditor _htmlEditor;
    private NavigationHiearchyAction _hiearchAction = new NavigationHiearchyAction(this);
    private QuickEditTabManager manager;
    private ISelectionListener _selListener;

    public WPETabbedPropertySheetPage(ITabbedPropertySheetPageContributor tabbedPropertySheetPageContributor, HTMLEditor editor) {
        super(tabbedPropertySheetPageContributor);
        this._htmlEditor = editor;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        Node node;
        if (part == null) {
            part = this._htmlEditor;
        }
        if ((part instanceof HTMLEditor || part instanceof ContentOutline) && (node = DesignerPropertyTool.normalizeSelectionToElement(part, selection, this._htmlEditor)) != null) {
            try {
                this._hiearchAction.refresh(node, node);
                this.getSite().getActionBars().getToolBarManager().update(true);
                super.selectionChanged(part, (ISelection)new StructuredSelection((Object)node));
            }
            catch (Exception exception) {}
        }
    }

    public void internalChangeSelection(Node selectedNode, Node innerNode) {
        this.getEditor().setFocus();
        this._hiearchAction.refresh(selectedNode, innerNode);
        this.getSite().getActionBars().getToolBarManager().update(true);
        super.selectionChanged((IWorkbenchPart)this.getEditor(), (ISelection)new StructuredSelection((Object)selectedNode));
    }

    public EditorPart getEditor() {
        return this._htmlEditor;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        this.setSelectionProvider();
        this.setSelectionListener();
        IToolBarManager toolbar = pageSite.getActionBars().getToolBarManager();
        toolbar.add((IAction)this._hiearchAction);
        this._hiearchAction.refresh(null, null);
    }

    private void setSelectionListener() {
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.getSelectionListener());
    }

    private ISelectionListener getSelectionListener() {
        if (this._selListener == null) {
            this._selListener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (WPETabbedPropertySheetPage.this.getEditor() == part) {
                        WPETabbedPropertySheetPage.this.selectionChanged(part, selection);
                    }
                }
            };
        }
        return this._selListener;
    }

    private void setSelectionProvider() {
        this.getSite().setSelectionProvider(new ISelectionProvider(){
            private ISelection _selection;

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public ISelection getSelection() {
                return this._selection;
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            }

            public void setSelection(ISelection selection) {
                this._selection = selection;
            }
        });
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), PDPlugin.getResourceString("WPETabbedPropertySheetPage.help.id"));
    }

    public QuickEditTabManager getTabManager() {
        if (this.manager == null) {
            this.manager = QuickEditTabManager.acquireInstance(this);
        }
        return this.manager;
    }

    public void dispose() {
        this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.getSelectionListener());
        this.getSite().setSelectionProvider(null);
        if (this.manager != null) {
            this.manager.releaseInstance();
            this.manager.dispose();
            this.manager = null;
        }
        this._selListener = null;
        this._htmlEditor = null;
        super.dispose();
    }
}

