/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.kdm.source.extension.discovery;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.discovery.core.AbstractModelDiscoverer;
import org.eclipse.modisco.kdm.source.extension.discovery.ISourceRegionNotifier;
import org.eclipse.modisco.kdm.source.extension.discovery.SourceVisitListener;

public abstract class AbstractRegionDiscoverer2<T>
extends AbstractModelDiscoverer<T>
implements ISourceRegionNotifier<T> {
    private List<SourceVisitListener> sourceVisitListeners;

    @Override
    public final void notifySourceRegionVisited(String filePath, int startOffset, int endOffset, int startLine, int endLine, EObject targetNode) {
        if (this.sourceVisitListeners != null && !this.sourceVisitListeners.isEmpty()) {
            for (SourceVisitListener listener : new ArrayList<SourceVisitListener>(this.sourceVisitListeners)) {
                listener.sourceRegionVisited(filePath, startOffset, endOffset, startLine, endLine, targetNode);
            }
        }
    }

    @Override
    public final void notifySourceRegionVisited(String filePath, int startOffset, int endOffset, EObject targetNode) {
        this.notifySourceRegionVisited(filePath, startOffset, endOffset, -1, -1, targetNode);
    }

    @Override
    public final void addSourceVisitListener(SourceVisitListener sourceVisitListener) {
        if (this.sourceVisitListeners == null) {
            this.sourceVisitListeners = new ArrayList<SourceVisitListener>();
        }
        if (sourceVisitListener != null && !this.sourceVisitListeners.contains(sourceVisitListener)) {
            this.sourceVisitListeners.add(sourceVisitListener);
        }
    }

    @Override
    public final void removeSourceVisitListener(SourceVisitListener sourceVisitListener) {
        if (this.sourceVisitListeners != null) {
            this.sourceVisitListeners.remove(sourceVisitListener);
        }
    }

    @Override
    public final List<SourceVisitListener> getSourceVisitListeners() {
        return Collections.unmodifiableList(this.sourceVisitListeners);
    }
}

