/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.splitter;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.Locator;
import org.eclipse.mylyn.wikitext.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.mylyn.wikitext.splitter.Messages;
import org.eclipse.mylyn.wikitext.splitter.SplitOutlineItem;

public class SplittingHtmlDocumentBuilder
extends DocumentBuilder {
    private SplitOutlineItem outline;
    private HtmlDocumentBuilder rootBuilder;
    private File rootFile;
    private boolean formatting;
    private HtmlDocumentBuilder out;
    private Writer writer;
    private File currentFile;
    private boolean navigationImages;
    private String navigationImagePath = "images";
    private boolean embeddedTableOfContents;

    public void setRootBuilder(HtmlDocumentBuilder rootBuilder) {
        this.rootBuilder = rootBuilder;
        this.out = rootBuilder;
    }

    public HtmlDocumentBuilder getRootBuilder() {
        return this.rootBuilder;
    }

    @Override
    public void beginDocument() {
        if (this.rootBuilder == null || this.out == null || this.rootFile == null) {
            throw new IllegalStateException();
        }
        this.currentFile = this.rootFile;
        this.out.beginDocument();
        this.documentHeader();
    }

    @Override
    public void acronym(String text, String definition) {
        this.out.acronym(text, definition);
    }

    public void addCssStylesheet(HtmlDocumentBuilder.Stylesheet stylesheet) {
        this.out.addCssStylesheet(stylesheet);
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        this.out.beginBlock(type, attributes);
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        SplitOutlineItem item = this.outline.getOutlineItemById(attributes.getId());
        if (item != null && !this.currentFile.getName().equals(item.getSplitTarget())) {
            try {
                this.documentFooter();
                this.out.endDocument();
                if (this.writer != null) {
                    this.writer.close();
                    this.writer = null;
                }
                this.currentFile = new File(this.rootFile.getParent(), item.getSplitTarget());
                this.writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.currentFile), StandardCharsets.UTF_8);
                HtmlDocumentBuilder builder = new HtmlDocumentBuilder(this.writer, this.formatting);
                this.rootBuilder.copyConfiguration(builder);
                if (item.getLabel() != null) {
                    Object title = this.rootBuilder.getTitle();
                    title = title == null ? item.getLabel() : (String)title + " - " + item.getLabel();
                    builder.setTitle((String)title);
                }
                this.out = builder;
                this.out.beginDocument();
                this.documentHeader();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.out.beginHeading(level, attributes);
    }

    private void documentFooter() {
        this.emitEmbeddedTableOfContentsFooter();
        this.emitNavigation(false);
    }

    private void emitNavigation(boolean header) {
        ImageAttributes imageAttributes;
        LinkAttributes linkAttributes;
        TableCellAttributes tableCellAttributes;
        String currentName = this.currentFile.getName();
        List<SplitOutlineItem> pageOrder = this.outline.getPageOrder();
        SplitOutlineItem previous = null;
        SplitOutlineItem next = null;
        SplitOutlineItem current = null;
        boolean foundPage = false;
        for (SplitOutlineItem page : pageOrder) {
            if (page.getSplitTarget().equals(currentName)) {
                foundPage = true;
                current = page;
                continue;
            }
            if (!foundPage) {
                previous = page;
                continue;
            }
            next = page;
            break;
        }
        boolean rootPage = this.rootFile.getName().equals(this.currentFile.getName());
        if (next == null && previous == null && rootPage) {
            return;
        }
        if (!header) {
            this.out.charactersUnescaped("<hr class=\"navigation-separator\"/>");
        }
        TableAttributes tableAttributes = new TableAttributes();
        tableAttributes.setCssClass("navigation");
        tableAttributes.setCssStyle("width: 100%;");
        tableAttributes.setBorder("0");
        tableAttributes.setSummary("navigation");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE, tableAttributes);
        if (header) {
            this.out.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
            tableCellAttributes = new TableCellAttributes();
            tableCellAttributes.setAlign("center");
            tableCellAttributes.setCssStyle("width: 100%");
            tableCellAttributes.setColspan("3");
            this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_HEADER, tableCellAttributes);
            if (rootPage) {
                this.out.characters(this.rootBuilder.getTitle());
            } else {
                this.out.characters(current == null ? "" : current.getLabel());
            }
            this.out.endBlock();
            this.out.endBlock();
        }
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        tableCellAttributes = new TableCellAttributes();
        tableCellAttributes.setAlign("left");
        tableCellAttributes.setCssStyle("width: 20%");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, tableCellAttributes);
        if (previous != null) {
            linkAttributes = new LinkAttributes();
            linkAttributes.setTitle(previous.getLabel());
            if (this.navigationImages) {
                imageAttributes = new ImageAttributes();
                imageAttributes.setAlt(Messages.getString("SplittingHtmlDocumentBuilder.Previous"));
                this.out.imageLink(linkAttributes, imageAttributes, previous.getSplitTarget(), this.computeNavImagePath(Messages.getString("SplittingHtmlDocumentBuilder.Previous_Image")));
            } else {
                this.out.link(linkAttributes, previous.getSplitTarget(), Messages.getString("SplittingHtmlDocumentBuilder.Previous"));
            }
        }
        this.out.endBlock();
        tableCellAttributes = new TableCellAttributes();
        tableCellAttributes.setAlign("center");
        tableCellAttributes.setCssStyle("width: 60%");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, tableCellAttributes);
        if (!header && !rootPage) {
            linkAttributes = new LinkAttributes();
            linkAttributes.setTitle(this.rootBuilder.getTitle());
            if (this.navigationImages) {
                imageAttributes = new ImageAttributes();
                imageAttributes.setAlt(this.rootBuilder.getTitle());
                this.out.imageLink(linkAttributes, imageAttributes, this.rootFile.getName(), this.computeNavImagePath(Messages.getString("SplittingHtmlDocumentBuilder.Home_Image")));
            } else {
                this.out.link(linkAttributes, this.rootFile.getName(), Messages.getString("SplittingHtmlDocumentBuilder.Home"));
            }
        }
        this.out.endBlock();
        tableCellAttributes = new TableCellAttributes();
        tableCellAttributes.setAlign("right");
        tableCellAttributes.setCssStyle("width: 20%");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, tableCellAttributes);
        if (next != null) {
            linkAttributes = new LinkAttributes();
            linkAttributes.setTitle(next.getLabel());
            if (this.navigationImages) {
                imageAttributes = new ImageAttributes();
                imageAttributes.setAlt(Messages.getString("SplittingHtmlDocumentBuilder.Next"));
                this.out.imageLink(linkAttributes, imageAttributes, next.getSplitTarget(), this.computeNavImagePath(Messages.getString("SplittingHtmlDocumentBuilder.Next_Image")));
            } else {
                this.out.link(linkAttributes, next.getSplitTarget(), Messages.getString("SplittingHtmlDocumentBuilder.Next"));
            }
        }
        this.out.endBlock();
        this.out.endBlock();
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_ROW, new Attributes());
        tableCellAttributes = new TableCellAttributes();
        tableCellAttributes.setAlign("left");
        tableCellAttributes.setValign("top");
        tableCellAttributes.setCssStyle("width: 20%");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, tableCellAttributes);
        if (previous != null) {
            this.out.characters(previous.getLabel());
        }
        this.out.endBlock();
        tableCellAttributes = new TableCellAttributes();
        tableCellAttributes.setAlign("center");
        tableCellAttributes.setCssStyle("width: 60%");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, tableCellAttributes);
        this.out.endBlock();
        tableCellAttributes = new TableCellAttributes();
        tableCellAttributes.setAlign("right");
        tableCellAttributes.setValign("top");
        tableCellAttributes.setCssStyle("width: 20%");
        this.out.beginBlock(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, tableCellAttributes);
        if (next != null) {
            this.out.characters(next.getLabel());
        }
        this.out.endBlock();
        this.out.endBlock();
        this.out.endBlock();
        if (header) {
            this.out.charactersUnescaped("<hr class=\"navigation-separator\"/>");
        }
    }

    private String computeNavImagePath(String imagePath) {
        if (this.navigationImagePath != null) {
            return this.navigationImagePath + "/" + imagePath;
        }
        return imagePath;
    }

    public String getNavigationImagePath() {
        return this.navigationImagePath;
    }

    public void setNavigationImagePath(String navigationImagePath) {
        this.navigationImagePath = navigationImagePath;
        if (this.navigationImagePath != null && this.navigationImagePath.endsWith("/")) {
            this.navigationImagePath = this.navigationImagePath.substring(0, this.navigationImagePath.length() - 1);
        }
    }

    private void documentHeader() {
        this.emitNavigation(true);
        this.emitEmbeddedTableOfContentsHeader();
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        if (type == DocumentBuilder.SpanType.LINK && attributes instanceof LinkAttributes) {
            LinkAttributes linkAttributes = (LinkAttributes)attributes;
            linkAttributes.setHref(this.adjustHref(linkAttributes.getHref()));
        }
        this.out.beginSpan(type, attributes);
    }

    @Override
    public void characters(String text) {
        this.out.characters(text);
    }

    @Override
    public void charactersUnescaped(String literal) {
        this.out.charactersUnescaped(literal);
    }

    public void copyConfiguration(HtmlDocumentBuilder other) {
        this.out.copyConfiguration(other);
    }

    @Override
    public void endBlock() {
        this.out.endBlock();
    }

    @Override
    public void endDocument() {
        this.documentFooter();
        this.out.endDocument();
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                throw new IllegalStateException();
            }
        }
        this.out = null;
    }

    @Override
    public void flush() {
        if (this.out != null) {
            this.out.flush();
        }
    }

    @Override
    public void endHeading() {
        this.out.endHeading();
    }

    @Override
    public void endSpan() {
        this.out.endSpan();
    }

    @Override
    public void entityReference(String entity) {
        this.out.entityReference(entity);
    }

    @Override
    public Locator getLocator() {
        return this.out.getLocator();
    }

    @Override
    public void image(Attributes attributes, String url) {
        this.out.image(attributes, url);
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        href = this.adjustHref(href);
        this.out.imageLink(linkAttributes, imageAttributes, href, imageUrl);
    }

    private String adjustHref(String href) {
        if (href != null && href.startsWith("#")) {
            href = this.getHrefOfHeading(href.substring(1));
        }
        return href;
    }

    private String getHrefOfHeading(String headingId) {
        SplitOutlineItem target = this.outline.getOutlineItemById(headingId);
        if (target != null) {
            SplitOutlineItem pageTarget = target;
            while (pageTarget.getParent() != null && pageTarget.getSplitTarget().equals(pageTarget.getParent().getSplitTarget())) {
                pageTarget = pageTarget.getParent();
            }
            if (!this.currentFile.getName().equals(pageTarget.getSplitTarget())) {
                String pageHref = pageTarget.getSplitTarget().replace(" ", "%20");
                return pageHref + "#" + headingId;
            }
        }
        return "#" + headingId;
    }

    @Override
    public void lineBreak() {
        this.out.lineBreak();
    }

    @Override
    public void horizontalRule() {
        this.out.horizontalRule();
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        hrefOrHashName = this.adjustHref(hrefOrHashName);
        this.out.link(attributes, hrefOrHashName, text);
    }

    @Override
    public void setLocator(Locator locator) {
        if (this.out != null) {
            this.out.setLocator(locator);
        }
    }

    public void setOutline(SplitOutlineItem outline) {
        this.outline = outline;
    }

    public SplitOutlineItem getOutline() {
        return this.outline;
    }

    public void setRootFile(File rootFile) {
        this.rootFile = rootFile;
    }

    public void setNavigationImages(boolean navigationImages) {
        this.navigationImages = navigationImages;
    }

    public boolean isNavigationImages() {
        return this.navigationImages;
    }

    public void setFormatting(boolean formatting) {
        this.formatting = formatting;
    }

    public boolean isFormatting() {
        return this.formatting;
    }

    public void setEmbeddedTableOfContents(boolean embeddedTableOfContents) {
        this.embeddedTableOfContents = embeddedTableOfContents;
    }

    public boolean isEmbeddedTableOfContents() {
        return this.embeddedTableOfContents;
    }

    private void emitEmbeddedTableOfContents() {
        String currentName = this.currentFile.getName();
        SplitOutlineItem pageItem = null;
        List<SplitOutlineItem> pageOrder = this.outline.getPageOrder();
        for (SplitOutlineItem item : pageOrder) {
            if (!item.getSplitTarget().equals(currentName)) continue;
            pageItem = item;
        }
        Preconditions.checkState((pageItem != null ? 1 : 0) != 0);
        this.emitToc(this.outline, 0);
    }

    private void emitToc(OutlineItem item, int level) {
        if (item.getChildren().isEmpty()) {
            return;
        }
        this.out.beginBlock(DocumentBuilder.BlockType.NUMERIC_LIST, new Attributes());
        for (OutlineItem child : item.getChildren()) {
            Attributes itemAttributes = new Attributes();
            if (this.isExpandedInTableOfContents(child)) {
                itemAttributes.appendCssClass("expanded");
            } else {
                itemAttributes.appendCssClass("collapsed");
            }
            this.out.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, itemAttributes);
            this.out.link(this.getHrefOfHeading(child.getId()), child.getLabel());
            this.emitToc(child, level + 1);
            this.out.endBlock();
        }
        this.out.endBlock();
    }

    private boolean isExpandedInTableOfContents(OutlineItem target) {
        SplitOutlineItem pageTarget = (SplitOutlineItem)target;
        while (pageTarget.getParent() != this.outline && pageTarget.getSplitTarget() == null) {
            pageTarget = pageTarget.getParent();
        }
        return pageTarget.getSplitTarget() == null || this.currentFile.getName().equals(pageTarget.getSplitTarget());
    }

    private void emitEmbeddedTableOfContentsHeader() {
        if (this.embeddedTableOfContents) {
            this.beginDiv("container");
            this.beginDiv("row");
            this.beginDiv("table-of-contents", "span2");
            this.out.beginHeading(1, new Attributes());
            this.out.characters(Messages.getString("SplittingHtmlDocumentBuilder.TableOfContentsHeading"));
            this.out.endHeading();
            this.emitEmbeddedTableOfContents();
            this.endDiv();
            this.beginDiv("main-content", "span10");
        }
    }

    private void beginDiv(String ... cssClasses) {
        Attributes attributes = new Attributes();
        String[] stringArray = cssClasses;
        int n = cssClasses.length;
        int n2 = 0;
        while (n2 < n) {
            String cssClass = stringArray[n2];
            attributes.appendCssClass(cssClass);
            ++n2;
        }
        this.out.beginBlock(DocumentBuilder.BlockType.DIV, attributes);
    }

    private void endDiv() {
        this.out.endBlock();
    }

    private void emitEmbeddedTableOfContentsFooter() {
        if (this.embeddedTableOfContents) {
            this.endDiv();
            this.endDiv();
            this.endDiv();
        }
    }
}

