/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.url;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.filesystem.core.internal.url.TcfURLConnection;
import org.eclipse.tcf.te.tcf.filesystem.core.nls.Messages;

public class TcfOutputStream
extends OutputStream {
    private static final int DEFAULT_CHUNK_SIZE = 5120;
    long position;
    byte[] buffer;
    int offset;
    boolean closed;
    Exception ERROR;
    TcfURLConnection connection;

    public TcfOutputStream(TcfURLConnection connection) {
        this(connection, 5120);
    }

    public TcfOutputStream(TcfURLConnection connection, int chunk_size) {
        this.connection = connection;
        this.buffer = new byte[chunk_size];
        this.offset = 0;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            throw new IOException(Messages.TcfOutputStream_StreamClosed);
        }
        if (this.ERROR != null) {
            IOException exception = new IOException(this.ERROR.toString());
            exception.initCause(this.ERROR);
            throw exception;
        }
        if (this.offset < this.buffer.length) {
            this.buffer[this.offset++] = (byte)b;
        }
        if (this.offset == this.buffer.length) {
            this.flush();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.offset > 0) {
            this.connection.service.write(this.connection.handle, this.position, this.buffer, 0, this.offset, new IFileSystem.DoneWrite(){

                public void doneWrite(IToken token, IFileSystem.FileSystemException error) {
                    if (error != null) {
                        TcfOutputStream.this.ERROR = error;
                    }
                    TcfOutputStream.this.position += (long)TcfOutputStream.this.offset;
                    TcfOutputStream.this.offset = 0;
                }
            });
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.connection.closeStream(this);
            this.closed = true;
        }
    }
}

