/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.trees;

import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.tcf.te.ui.trees.AbstractTreeControl;
import org.eclipse.tcf.te.ui.trees.ColumnDescriptor;
import org.eclipse.tcf.te.ui.trees.ContentDescriptor;
import org.eclipse.tcf.te.ui.trees.TreeViewerSorterCaseInsensitive;

public class TreeControlSorter
extends TreeViewerSorterCaseInsensitive {
    private final AbstractTreeControl parentTreeControl;

    public TreeControlSorter(AbstractTreeControl parentTreeControl) {
        Assert.isNotNull((Object)((Object)parentTreeControl));
        this.parentTreeControl = parentTreeControl;
    }

    @Override
    public int compare(Viewer viewer, Object e1, Object e2) {
        ContentDescriptor c1 = null;
        ContentDescriptor c2 = null;
        int inverter = this.doDetermineInverter(viewer);
        ContentDescriptor[] descriptors = this.parentTreeControl.getContentDescriptors();
        if (descriptors != null) {
            ContentDescriptor descriptor;
            ContentDescriptor[] contentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                descriptor = contentDescriptorArray[n2];
                if (descriptor.getContentContribution() != null && descriptor.getContentContribution().isElementHandled(e1)) {
                    c1 = descriptor;
                    break;
                }
                ++n2;
            }
            contentDescriptorArray = descriptors;
            n = descriptors.length;
            n2 = 0;
            while (n2 < n) {
                descriptor = contentDescriptorArray[n2];
                if (descriptor.getContentContribution() != null && descriptor.getContentContribution().isElementHandled(e2)) {
                    c2 = descriptor;
                    break;
                }
                ++n2;
            }
        }
        if (c1 == null && c2 == null && viewer instanceof TreeViewer) {
            Comparator<Object> comparator;
            ColumnDescriptor column;
            Tree tree = ((TreeViewer)viewer).getTree();
            TreeColumn treeColumn = tree.getSortColumn();
            if (treeColumn == null) {
                treeColumn = tree.getColumn(0);
            }
            if (treeColumn != null && !treeColumn.isDisposed() && (column = (ColumnDescriptor)treeColumn.getData()) != null && (comparator = column.getComparator()) != null) {
                return inverter * comparator.compare(e1, e2);
            }
        }
        if (c1 == null && c2 != null || c1 != null && c2 == null) {
            return inverter * (c1 == null ? -1 : 1);
        }
        if (c1 != null && c2 != null && !c1.equals(c2)) {
            return inverter * Integer.valueOf(c1.getRank()).compareTo(c2.getRank());
        }
        return super.compare(viewer, e1, e2);
    }
}

