/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.viewers.runtime.model;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.viatra.addon.viewers.runtime.model.EventFilterBuilder;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerFilterDefinition;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.notation.FormatSpecification;
import org.eclipse.viatra.addon.viewers.runtime.notation.Item;
import org.eclipse.viatra.addon.viewers.runtime.notation.NotationPackage;
import org.eclipse.viatra.addon.viewers.runtime.specifications.ItemQuerySpecificationDescriptor;
import org.eclipse.viatra.addon.viewers.runtime.util.FormatParser;
import org.eclipse.viatra.addon.viewers.runtime.util.LabelParser;
import org.eclipse.viatra.query.runtime.api.GenericPatternMatch;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.viatra.transformation.views.core.ViewModelManager;
import org.eclipse.viatra.transformation.views.core.ViewModelRule;
import org.eclipse.viatra.transformation.views.core.util.ViewModelUtil;
import org.eclipse.viatra.transformation.views.traceability.generic.AbstractQuerySpecificationDescriptor;

public class ItemRule
extends ViewModelRule {
    private final ItemQuerySpecificationDescriptor descriptor;
    private final ViewerState state;
    private ViewerDataFilter baseFilter;

    private ItemRule(ItemQuerySpecificationDescriptor descriptor, ViewerState state, ViewerDataFilter filter) {
        super((AbstractQuerySpecificationDescriptor)descriptor);
        this.state = state;
        this.descriptor = descriptor;
        this.baseFilter = filter;
    }

    public static ItemRule initiate(IQuerySpecification<?> specification, PAnnotation annotation, ViewerState state, ViewerDataFilter filter) {
        ItemQuerySpecificationDescriptor descriptor = new ItemQuerySpecificationDescriptor(specification, annotation);
        return new ItemRule(descriptor, state, filter);
    }

    private EventFilter<IPatternMatch> createFilter(ViewerDataFilter baseFilter) {
        if (!baseFilter.isFiltered(this.getBaseSpecification())) {
            return null;
        }
        ViewerFilterDefinition filterDefinition = baseFilter.getFilter(this.getBaseSpecification());
        return EventFilterBuilder.createEventFilter(filterDefinition, this.getReferencedSpecification());
    }

    public Job<GenericPatternMatch> getAppearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, match -> {
            Object param = match.get(this.descriptor.getSource());
            EObject eObject = ViewModelUtil.create((EClass)NotationPackage.eINSTANCE.getItem(), (EObject)this.state.getNotationModel(), (EReference)NotationPackage.eINSTANCE.getNotationModel_Items());
            ViewModelUtil.trace((ViewModelManager)this.state.getManager(), (String)this.getReferencedSpecification().getFullyQualifiedName(), Collections.singleton(eObject), (Object[])new Object[]{param});
            Item item = (Item)eObject;
            if (param instanceof EObject) {
                item.setParamEObject((EObject)param);
            } else {
                item.setParamObject(param);
            }
            item.setPolicy(this.descriptor.getPolicy());
            item.setLabel(LabelParser.calculateLabel(match, this.descriptor.getLabel()));
            if (this.descriptor.isFormatted()) {
                FormatSpecification formatSpecification = FormatParser.parseFormatAnnotation(this.descriptor.getFormatAnnotation());
                item.setFormat(formatSpecification);
            }
            this.state.itemAppeared(item);
            this.logger.debug((Object)("Item appeared: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + item.toString()));
        }));
    }

    public Job<GenericPatternMatch> getDisappearedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, match -> {
            if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Item) {
                Collection deletedItems = ViewModelUtil.delete((GenericPatternMatch)match);
                for (EObject item : deletedItems) {
                    this.state.itemDisappeared((Item)item);
                    this.logger.debug((Object)("Item disappeared: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + item.toString()));
                }
            }
        }));
    }

    public Job<GenericPatternMatch> getUpdatedJob() {
        return Jobs.newErrorLoggingJob((Job)Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, match -> {
            String newLabel;
            Item item;
            String oldLabel;
            if (ViewModelUtil.target((GenericPatternMatch)match) instanceof Item && !(oldLabel = (item = (Item)ViewModelUtil.target((GenericPatternMatch)match)).getLabel()).equals(newLabel = LabelParser.calculateLabel(match, this.descriptor.getLabel()))) {
                item.setLabel(newLabel);
                this.state.labelUpdated(item, newLabel);
                this.logger.debug((Object)("Item updated: <" + this.getTracedSpecification().getFullyQualifiedName() + ">" + item.toString()));
            }
        }));
    }

    protected EventFilter<IPatternMatch> prepareFilter() {
        return this.createFilter(this.baseFilter);
    }
}

