/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.eval.evaluators;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.NumberLiteral;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.IExpressionEvaluator;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;

public final class LongEvaluator
implements IExpressionEvaluator {
    /*
     * WARNING - void declaration
     */
    @Override
    public Object evaluate(EvaluationContext context, Expression expression, ITypeBinding typeBinding, String typeQualifiedName) throws Exception {
        if ("long".equals(typeQualifiedName)) {
            Expression expression2;
            InfixExpression operator;
            Expression expression3 = expression;
            if (expression3 instanceof NumberLiteral) {
                void numberLiteral;
                NumberLiteral numberLiteral2 = (NumberLiteral)expression3;
                NumberLiteral cfr_ignored_0 = (NumberLiteral)expression3;
                String token = numberLiteral.getToken();
                token = StringUtils.stripEnd((String)token, (String)"Ll");
                if (token.startsWith("0x")) {
                    return Long.valueOf(token.substring(2), 16);
                }
                if (token.startsWith("0")) {
                    return Long.valueOf(token, 8);
                }
                return Long.valueOf(token);
            }
            Expression expression4 = expression;
            if (expression4 instanceof PrefixExpression) {
                void prefixExpression;
                PrefixExpression token = (PrefixExpression)expression4;
                PrefixExpression cfr_ignored_1 = (PrefixExpression)expression4;
                operator = prefixExpression.getOperator();
                Expression operand = prefixExpression.getOperand();
                long operandValue = LongEvaluator.getLongValue(context, operand);
                if (operator == PrefixExpression.Operator.PLUS) {
                    return operandValue;
                }
                if (operator == PrefixExpression.Operator.MINUS) {
                    return -operandValue;
                }
            }
            if ((expression2 = expression) instanceof InfixExpression) {
                void infixExpression;
                operator = (InfixExpression)expression2;
                InfixExpression cfr_ignored_2 = (InfixExpression)expression2;
                List<Expression> extendedOperands = DomGenerics.extendedOperands((InfixExpression)infixExpression);
                long[] operands = new long[2 + extendedOperands.size()];
                operands[0] = LongEvaluator.getLongValue(context, infixExpression.getLeftOperand());
                operands[1] = LongEvaluator.getLongValue(context, infixExpression.getRightOperand());
                int i = 0;
                while (i < extendedOperands.size()) {
                    Expression operandExpression = extendedOperands.get(i);
                    operands[2 + i] = LongEvaluator.getLongValue(context, operandExpression);
                    ++i;
                }
                long value = operands[0];
                InfixExpression.Operator operator2 = infixExpression.getOperator();
                int i2 = 1;
                while (i2 < operands.length) {
                    long operand = operands[i2];
                    if (operator2 == InfixExpression.Operator.PLUS) {
                        value += operand;
                    } else if (operator2 == InfixExpression.Operator.MINUS) {
                        value -= operand;
                    } else if (operator2 == InfixExpression.Operator.TIMES) {
                        value *= operand;
                    } else if (operator2 == InfixExpression.Operator.DIVIDE) {
                        value /= operand;
                    } else if (operator2 == InfixExpression.Operator.REMAINDER) {
                        value %= operand;
                    } else if (operator2 == InfixExpression.Operator.OR) {
                        value |= operand;
                    } else if (operator2 == InfixExpression.Operator.AND) {
                        value &= operand;
                    }
                    ++i2;
                }
                return value;
            }
        }
        return AstEvaluationEngine.UNKNOWN;
    }

    /*
     * WARNING - void declaration
     */
    private static long getLongValue(EvaluationContext context, Expression expression) throws Exception {
        Object value = AstEvaluationEngine.evaluate(context, expression);
        Object object = value;
        if (object instanceof Character) {
            void character;
            Character c = (Character)object;
            Character cfr_ignored_0 = (Character)object;
            return character.charValue();
        }
        Number number = (Number)value;
        return number.longValue();
    }
}

