/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.animation;

import org.eclipse.xwt.XWTException;
import org.eclipse.xwt.animation.EasingFunctionBase;

public class BounceEase
extends EasingFunctionBase {
    private int bounces = 5;
    private double bounciness = 2.0;

    public int getBounces() {
        return this.bounces;
    }

    public void setBounces(int bounces) {
        this.bounces = bounces;
    }

    public double getBounciness() {
        return this.bounciness;
    }

    public void setBounciness(double bounciness) {
        this.bounciness = bounciness;
    }

    @Override
    public double ease(double normalizedTime) {
        switch (this.getEasingMode()) {
            case EaseIn: {
                return BounceEase.easeValue(normalizedTime, this.getBounces(), this.getBounciness());
            }
            case EaseOut: {
                return 1.0 - BounceEase.easeValue(1.0 - normalizedTime, this.getBounces(), this.getBounciness());
            }
            case EaseInOut: {
                normalizedTime /= 0.5;
                if (normalizedTime < 1.0) {
                    return BounceEase.easeValue(normalizedTime, this.getBounces(), this.getBounciness()) / 2.0;
                }
                return (2.0 - BounceEase.easeValue(2.0 - normalizedTime, this.getBounces(), this.getBounciness())) / 2.0;
            }
        }
        throw new XWTException(this.getEasingMode().name() + " is supported.");
    }

    protected static double easeValue(double current, int bounces, double bounciness) {
        if (current == 0.0) {
            return 0.0;
        }
        if (current == 1.0) {
            return 1.0;
        }
        double angle = Math.PI * (double)(bounces + 1);
        double s = Math.asin(1.0) / angle;
        return Math.pow(2.0, 10.0 * (current -= 1.0)) * Math.abs(Math.sin((current - s) * angle));
    }
}

