/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.jface;

import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.XWT;
import org.eclipse.xwt.databinding.BindingContext;

public class XWTTitleAreaDialog
extends TitleAreaDialog {
    private Object dataContext;
    private BindingContext bindingContext;
    private AggregateValidationStatus validationStatus;
    private Class<?> contentCLS;

    public XWTTitleAreaDialog(Shell parentShell, Object dataContext, BindingContext bindingContext) {
        super(parentShell);
        this.dataContext = dataContext;
        this.bindingContext = bindingContext;
    }

    public XWTTitleAreaDialog(Shell parentShell, Class<?> contentCLS, Object dataContext) {
        this(parentShell, contentCLS, dataContext, null);
    }

    public XWTTitleAreaDialog(Shell parentShell, Class<?> contentCLS, Object dataContext, BindingContext bindingContext) {
        super(parentShell);
        this.contentCLS = contentCLS;
        this.dataContext = dataContext;
        this.bindingContext = bindingContext;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        if (this.bindingContext == null) {
            this.bindingContext = new BindingContext((Widget)parent);
        }
        this.validationStatus = this.bindingContext.getStatus();
        this.validationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IStatus status = (IStatus)XWTTitleAreaDialog.this.validationStatus.getValue();
                XWTTitleAreaDialog.this.setMessage(status.getMessage(), status.getSeverity());
            }
        });
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                BindingContext bindingContext;
                Thread.currentThread().setContextClassLoader(this.contentCLS.getClassLoader());
                HashMap<String, Object> newOptions = new HashMap<String, Object>();
                newOptions.put("XWT.Container", parent);
                Object dataContext = this.getDataContext();
                if (dataContext != null) {
                    newOptions.put("XWT.DataContext", dataContext);
                }
                if ((bindingContext = this.getBindingContext()) != null) {
                    newOptions.put("XWT.BindingContext", bindingContext);
                }
                newOptions.put("XWT.Class", this.contentCLS);
                XWT.loadWithOptions(this.getContentURL(), newOptions);
                GridLayoutFactory.fillDefaults().generateLayout(parent);
                parent.layout(true, true);
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.currentThread().setContextClassLoader(classLoader);
                parent.setVisible(true);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(classLoader);
            parent.setVisible(true);
        }
        return control;
    }

    public URL getContentURL() {
        if (this.contentCLS != null) {
            return this.contentCLS.getResource(this.contentCLS.getSimpleName() + ".xwt");
        }
        return null;
    }

    public Object getDataContext() {
        return this.dataContext;
    }

    public BindingContext getBindingContext() {
        return this.bindingContext;
    }
}

