/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ContainerUpdate;

final class ImmutableContainerUpdate
implements ContainerUpdate {
    @Nullable
    private final List<String> warnings;

    private ImmutableContainerUpdate(@Nullable List<String> warnings) {
        this.warnings = warnings;
    }

    @Override
    @JsonProperty(value="Warnings")
    @Nullable
    public List<String> warnings() {
        return this.warnings;
    }

    public final ImmutableContainerUpdate withWarnings(String ... elements) {
        if (elements == null) {
            return new ImmutableContainerUpdate(null);
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableContainerUpdate.createUnmodifiableList(false, ImmutableContainerUpdate.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableContainerUpdate(newValue);
    }

    public final ImmutableContainerUpdate withWarnings(@Nullable Iterable<String> elements) {
        if (this.warnings == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableContainerUpdate.createUnmodifiableList(false, ImmutableContainerUpdate.createSafeList(elements, true, false));
        return new ImmutableContainerUpdate(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContainerUpdate && this.equalTo(0, (ImmutableContainerUpdate)another);
    }

    private boolean equalTo(int synthetic, ImmutableContainerUpdate another) {
        return Objects.equals(this.warnings, another.warnings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.warnings);
        return h;
    }

    public String toString() {
        return "ContainerUpdate{warnings=" + this.warnings + "}";
    }

    public static ImmutableContainerUpdate copyOf(ContainerUpdate instance) {
        if (instance instanceof ImmutableContainerUpdate) {
            return (ImmutableContainerUpdate)instance;
        }
        return ImmutableContainerUpdate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    static final class Builder
    implements ContainerUpdate.Builder {
        private List<String> warnings = null;

        private Builder() {
        }

        public final Builder from(ContainerUpdate instance) {
            Objects.requireNonNull(instance, "instance");
            List<String> warningsValue = instance.warnings();
            if (warningsValue != null) {
                this.addAllWarnings(warningsValue);
            }
            return this;
        }

        public final Builder warning(String element) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            return this;
        }

        public final Builder warnings(String ... elements) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @Override
        @JsonProperty(value="Warnings")
        public final Builder warnings(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.warnings = null;
                return this;
            }
            this.warnings = new ArrayList<String>();
            return this.addAllWarnings(elements);
        }

        public final Builder addAllWarnings(Iterable<String> elements) {
            Objects.requireNonNull(elements, "warnings element");
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>();
            }
            for (String element : elements) {
                this.warnings.add(Objects.requireNonNull(element, "warnings element"));
            }
            return this;
        }

        @Override
        public ImmutableContainerUpdate build() {
            return new ImmutableContainerUpdate(this.warnings == null ? null : ImmutableContainerUpdate.createUnmodifiableList(true, this.warnings));
        }
    }
}

