/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Date;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.SignaturePacket;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.IssuerKeyID;
import org.bouncycastle.bcpg.sig.SignatureCreationTime;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPOnePassSignature;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class PGPSignatureGenerator
extends PGPDefaultSignatureGenerator {
    private SignatureSubpacket[] unhashed = new SignatureSubpacket[0];
    private SignatureSubpacket[] hashed = new SignatureSubpacket[0];
    private PGPContentSignerBuilder contentSignerBuilder;
    private PGPContentSigner contentSigner;
    private int providedKeyAlgorithm = -1;

    public PGPSignatureGenerator(PGPContentSignerBuilder pGPContentSignerBuilder) {
        this.contentSignerBuilder = pGPContentSignerBuilder;
    }

    public void init(int n, PGPPrivateKey pGPPrivateKey) throws PGPException {
        this.contentSigner = this.contentSignerBuilder.build(n, pGPPrivateKey);
        this.sigOut = this.contentSigner.getOutputStream();
        this.sigType = this.contentSigner.getType();
        this.lastb = 0;
        if (this.providedKeyAlgorithm >= 0 && this.providedKeyAlgorithm != this.contentSigner.getKeyAlgorithm()) {
            throw new PGPException("key algorithm mismatch");
        }
    }

    public void setHashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.hashed = new SignatureSubpacket[0];
            return;
        }
        this.hashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public void setUnhashedSubpackets(PGPSignatureSubpacketVector pGPSignatureSubpacketVector) {
        if (pGPSignatureSubpacketVector == null) {
            this.unhashed = new SignatureSubpacket[0];
            return;
        }
        this.unhashed = pGPSignatureSubpacketVector.toSubpacketArray();
    }

    public PGPOnePassSignature generateOnePassVersion(boolean bl) throws PGPException {
        return new PGPOnePassSignature(new OnePassSignaturePacket(this.sigType, this.contentSigner.getHashAlgorithm(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getKeyID(), bl));
    }

    public PGPSignature generate() throws PGPException {
        MPInteger[] mPIntegerArray;
        byte[] byArray;
        byte[] byArray2;
        Object object;
        int n = 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        SignatureSubpacket[] signatureSubpacketArray = this.packetNotPresent(this.hashed, 2) ? this.insertSubpacket(this.hashed, new SignatureCreationTime(false, new Date())) : this.hashed;
        SignatureSubpacket[] signatureSubpacketArray2 = this.packetNotPresent(this.hashed, 16) && this.packetNotPresent(this.unhashed, 16) ? this.insertSubpacket(this.unhashed, new IssuerKeyID(false, this.contentSigner.getKeyID())) : this.unhashed;
        try {
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write((byte)this.sigType);
            byteArrayOutputStream.write((byte)this.contentSigner.getKeyAlgorithm());
            byteArrayOutputStream.write((byte)this.contentSigner.getHashAlgorithm());
            object = new ByteArrayOutputStream();
            for (int i = 0; i != signatureSubpacketArray.length; ++i) {
                signatureSubpacketArray[i].encode((OutputStream)object);
            }
            byArray2 = ((ByteArrayOutputStream)object).toByteArray();
            byteArrayOutputStream.write((byte)(byArray2.length >> 8));
            byteArrayOutputStream.write((byte)byArray2.length);
            byteArrayOutputStream.write(byArray2);
            byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.write((byte)n);
            byteArrayOutputStream.write(-1);
            byteArrayOutputStream.write((byte)(byArray.length >> 24));
            byteArrayOutputStream.write((byte)(byArray.length >> 16));
            byteArrayOutputStream.write((byte)(byArray.length >> 8));
            byteArrayOutputStream.write((byte)byArray.length);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding hashed data.", iOException);
        }
        object = byteArrayOutputStream.toByteArray();
        this.blockUpdate((byte[])object, 0, ((Object)object).length);
        if (this.contentSigner.getKeyAlgorithm() == 3 || this.contentSigner.getKeyAlgorithm() == 1) {
            mPIntegerArray = new MPInteger[]{new MPInteger(new BigInteger(1, this.contentSigner.getSignature()))};
        } else if (this.contentSigner.getKeyAlgorithm() == 22 || this.contentSigner.getKeyAlgorithm() == 27 || this.contentSigner.getKeyAlgorithm() == 28) {
            byArray2 = this.contentSigner.getSignature();
            mPIntegerArray = new MPInteger[]{new MPInteger(new BigInteger(1, Arrays.copyOfRange((byte[])byArray2, (int)0, (int)(byArray2.length / 2)))), new MPInteger(new BigInteger(1, Arrays.copyOfRange((byte[])byArray2, (int)(byArray2.length / 2), (int)byArray2.length)))};
        } else {
            mPIntegerArray = PGPUtil.dsaSigToMpi(this.contentSigner.getSignature());
        }
        byArray2 = this.contentSigner.getDigest();
        byArray = new byte[]{byArray2[0], byArray2[1]};
        return new PGPSignature(new SignaturePacket(this.sigType, this.contentSigner.getKeyID(), this.contentSigner.getKeyAlgorithm(), this.contentSigner.getHashAlgorithm(), signatureSubpacketArray, signatureSubpacketArray2, byArray, mPIntegerArray));
    }

    public PGPSignature generateCertification(String string, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithIdData(180, Strings.toUTF8ByteArray((String)string));
        return this.generate();
    }

    public PGPSignature generateCertification(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPPublicKey pGPPublicKey) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.getAttributesHash(pGPUserAttributeSubpacketVector);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2) throws PGPException {
        this.updateWithPublicKey(pGPPublicKey);
        this.updateWithPublicKey(pGPPublicKey2);
        return this.generate();
    }

    public PGPSignature generateCertification(PGPPublicKey pGPPublicKey) throws PGPException {
        if (!(this.sigType != 40 && this.sigType != 24 || pGPPublicKey.isMasterKey())) {
            throw new IllegalArgumentException("certifications involving subkey requires public key of revoking key as well.");
        }
        this.updateWithPublicKey(pGPPublicKey);
        return this.generate();
    }

    private boolean packetNotPresent(SignatureSubpacket[] signatureSubpacketArray, int n) {
        for (int i = 0; i != signatureSubpacketArray.length; ++i) {
            if (signatureSubpacketArray[i].getType() != n) continue;
            return false;
        }
        return true;
    }

    private SignatureSubpacket[] insertSubpacket(SignatureSubpacket[] signatureSubpacketArray, SignatureSubpacket signatureSubpacket) {
        SignatureSubpacket[] signatureSubpacketArray2 = new SignatureSubpacket[signatureSubpacketArray.length + 1];
        signatureSubpacketArray2[0] = signatureSubpacket;
        System.arraycopy(signatureSubpacketArray, 0, signatureSubpacketArray2, 1, signatureSubpacketArray.length);
        return signatureSubpacketArray2;
    }
}

