/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.lm.reviews.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import org.eclipse.emf.cdo.etypes.impl.ModelElementImpl;
import org.eclipse.emf.cdo.lm.System;
import org.eclipse.emf.cdo.lm.reviews.Comment;
import org.eclipse.emf.cdo.lm.reviews.CommentStatus;
import org.eclipse.emf.cdo.lm.reviews.Commentable;
import org.eclipse.emf.cdo.lm.reviews.Review;
import org.eclipse.emf.cdo.lm.reviews.ReviewsPackage;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class CommentableImpl
extends ModelElementImpl
implements Commentable {
    protected static final int COMMENT_COUNT_EDEFAULT = 0;
    protected static final int UNRESOLVED_COUNT_EDEFAULT = 0;
    protected static final int RESOLVED_COUNT_EDEFAULT = 0;

    protected CommentableImpl() {
    }

    protected EClass eStaticClass() {
        return ReviewsPackage.Literals.COMMENTABLE;
    }

    @Override
    public abstract Review getReview();

    @Override
    public EList<Comment> getComments() {
        return (EList)this.eDynamicGet(2, (EStructuralFeature)ReviewsPackage.Literals.COMMENTABLE__COMMENTS, true, true);
    }

    @Override
    public int getCommentCount() {
        return CommentableImpl.getCommentCount(this);
    }

    @Override
    public int getUnresolvedCount() {
        return CommentableImpl.getUnresolvedCount(this);
    }

    @Override
    public int getResolvedCount() {
        return CommentableImpl.getResolvedCount(this);
    }

    public abstract System getSystem();

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getComments()).basicAdd((Object)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getComments()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getReview();
            }
            case 2: {
                return this.getComments();
            }
            case 3: {
                return this.getCommentCount();
            }
            case 4: {
                return this.getUnresolvedCount();
            }
            case 5: {
                return this.getResolvedCount();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 2: {
                this.getComments().clear();
                this.getComments().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 2: {
                this.getComments().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return this.getReview() != null;
            }
            case 2: {
                return !this.getComments().isEmpty();
            }
            case 3: {
                return this.getCommentCount() != 0;
            }
            case 4: {
                return this.getUnresolvedCount() != 0;
            }
            case 5: {
                return this.getResolvedCount() != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getSystem();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public static CommentStatistics getCommentStatistics(Commentable commentable) {
        CommentStatistics statistics = new CommentStatistics();
        CommentableImpl.updateCommentStatistics(statistics, commentable);
        return statistics;
    }

    static void updateCommentStatistics(CommentStatistics statistics, Commentable commentable) {
        if (commentable instanceof Comment) {
            Comment comment = (Comment)commentable;
            CommentStatus status = comment.getStatus();
            if (status == CommentStatus.NONE) {
                statistics.incNoneCount();
            } else if (status == CommentStatus.UNRESOLVED) {
                statistics.incUnresolvedCount();
            } else if (status == CommentStatus.RESOLVED) {
                statistics.incResolvedCount();
            }
        }
        for (Comment comment : commentable.getComments()) {
            CommentableImpl.updateCommentStatistics(statistics, comment);
        }
    }

    static int getCommentCount(Commentable commentable) {
        CommentStatistics statistics = CommentableImpl.getCommentStatistics(commentable);
        return statistics.getTotalCount();
    }

    static int getUnresolvedCount(Commentable commentable) {
        CommentStatistics statistics = CommentableImpl.getCommentStatistics(commentable);
        return statistics.getUnresolvedCount();
    }

    static int getResolvedCount(Commentable commentable) {
        CommentStatistics statistics = CommentableImpl.getCommentStatistics(commentable);
        return statistics.getResolvedCount();
    }

    public static final class CommentStatistics {
        private int noneCount;
        private int unresolvedCount;
        private int resolvedCount;

        private CommentStatistics() {
        }

        private void incNoneCount() {
            ++this.noneCount;
        }

        private void incUnresolvedCount() {
            ++this.unresolvedCount;
        }

        private void incResolvedCount() {
            ++this.resolvedCount;
        }

        public int getTotalCount() {
            return this.noneCount + this.unresolvedCount + this.resolvedCount;
        }

        public int getNoneCount() {
            return this.noneCount;
        }

        public int getUnresolvedCount() {
            return this.unresolvedCount;
        }

        public int getResolvedCount() {
            return this.resolvedCount;
        }
    }
}

