/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.notification;

import java.util.ArrayList;
import org.eclipse.graphiti.dt.IDiagramTypeProvider;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.notification.INotificationService;

public class DefaultNotificationService
implements INotificationService {
    private IDiagramTypeProvider diagramTypeProvider;

    public DefaultNotificationService(IDiagramTypeProvider diagramTypeProvider) {
        this.diagramTypeProvider = diagramTypeProvider;
    }

    protected IDiagramTypeProvider getDiagramTypeProvider() {
        return this.diagramTypeProvider;
    }

    @Override
    public void updatePictogramElements(PictogramElement[] dirtyPes) {
        IDiagramTypeProvider dtp = this.getDiagramTypeProvider();
        IFeatureProvider fp = dtp.getFeatureProvider();
        PictogramElement[] pictogramElementArray = dirtyPes;
        int n = dirtyPes.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement pe = pictogramElementArray[n2];
            UpdateContext updateContext = new UpdateContext(pe);
            fp.updateIfPossibleAndNeeded(updateContext);
            ++n2;
        }
    }

    protected PictogramElement[] calculateLinkedPictogramElements(ArrayList<Object> changedAndRelatedBOsList) {
        ArrayList<PictogramElement> retList = new ArrayList<PictogramElement>();
        IFeatureProvider featureProvider = this.getDiagramTypeProvider().getFeatureProvider();
        for (Object crbo : changedAndRelatedBOsList) {
            PictogramElement[] allPictogramElementsForBusinessObject;
            PictogramElement[] pictogramElementArray = allPictogramElementsForBusinessObject = featureProvider.getAllPictogramElementsForBusinessObject(crbo);
            int n = allPictogramElementsForBusinessObject.length;
            int n2 = 0;
            while (n2 < n) {
                PictogramElement pe = pictogramElementArray[n2];
                retList.add(pe);
                ++n2;
            }
        }
        return retList.toArray(new PictogramElement[0]);
    }

    @Override
    public PictogramElement[] calculateRelatedPictogramElements(Object[] changedBOs) {
        Object[] relatedBOs;
        ArrayList<Object> changedAndRelatedBOsList = new ArrayList<Object>();
        Object[] objectArray = changedBOs;
        int n = changedBOs.length;
        int n2 = 0;
        while (n2 < n) {
            Object cbo = objectArray[n2];
            changedAndRelatedBOsList.add(cbo);
            ++n2;
        }
        Object[] objectArray2 = relatedBOs = this.getDiagramTypeProvider().getRelatedBusinessObjects(changedBOs);
        int n3 = relatedBOs.length;
        n = 0;
        while (n < n3) {
            Object rbo = objectArray2[n];
            changedAndRelatedBOsList.add(rbo);
            ++n;
        }
        return this.calculateLinkedPictogramElements(changedAndRelatedBOsList);
    }
}

