/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.linkedediting;

import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerLifecycle;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.internal.CancellationUtil;
import org.eclipse.lsp4e.internal.NullSafetyHelper;
import org.eclipse.lsp4e.operations.linkedediting.LSPLinkedEditingBase;
import org.eclipse.lsp4j.LinkedEditingRanges;
import org.eclipse.lsp4j.Range;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LSPLinkedEditingReconcilingStrategy
extends LSPLinkedEditingBase
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ITextViewerLifecycle {
    private @Nullable ISourceViewer sourceViewer;
    private @Nullable IDocument document;
    private @Nullable EditorSelectionChangedListener editorSelectionChangedListener;
    private @Nullable Job highlightJob;
    private @Nullable LinkedModeModel linkedModel;

    public void install(ITextViewer viewer) {
        if (viewer instanceof ISourceViewer) {
            ISourceViewer thisViewer = (ISourceViewer)viewer;
            super.install();
            this.sourceViewer = thisViewer;
            this.editorSelectionChangedListener = new EditorSelectionChangedListener();
            this.editorSelectionChangedListener.install(thisViewer.getSelectionProvider());
        }
    }

    @Override
    public void uninstall() {
        if (this.sourceViewer != null && this.editorSelectionChangedListener != null) {
            this.editorSelectionChangedListener.uninstall(this.sourceViewer.getSelectionProvider());
        }
        super.uninstall();
    }

    @Override
    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        super.preferenceChange(event);
        if (event.getKey().equals("org.eclipse.ui.genericeditor.linkedediting") && this.fEnabled) {
            this.initialReconcile();
        }
    }

    public void setProgressMonitor(@Nullable IProgressMonitor monitor) {
    }

    public void initialReconcile() {
        ISourceViewer sourceViewer = this.sourceViewer;
        if (sourceViewer != null) {
            ISelectionProvider selectionProvider = sourceViewer.getSelectionProvider();
            StyledText textWidget = sourceViewer.getTextWidget();
            if (textWidget != null && selectionProvider != null) {
                textWidget.getDisplay().asyncExec(() -> {
                    if (!textWidget.isDisposed()) {
                        this.updateLinkedEditing(selectionProvider.getSelection());
                    }
                });
            }
        }
    }

    public void setDocument(@Nullable IDocument document) {
        this.document = document;
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
    }

    public void reconcile(IRegion partition) {
    }

    private void updateLinkedEditing(ISelection selection) {
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)selection;
            this.updateLinkedEditing(textSelection.getOffset());
        }
    }

    private void updateLinkedEditing(int offset) {
        LinkedModeModel linkedModel = this.linkedModel;
        if (this.sourceViewer != null && this.document != null && this.fEnabled && (linkedModel == null || !linkedModel.anyPositionContains(offset))) {
            if (linkedModel != null) {
                linkedModel.exit(1);
                this.linkedModel = null;
            }
            ((CompletableFuture)this.collectLinkedEditingRanges(this.document, offset).thenAcceptAsync(optional -> optional.ifPresent(this::applyLinkedEdit))).exceptionally(e -> {
                if (!CancellationUtil.isRequestCancelledException(e)) {
                    LanguageServerPlugin.logError(e);
                }
                return null;
            });
        }
    }

    private void applyLinkedEdit(final @Nullable LinkedEditingRanges ranges) {
        if (this.highlightJob != null) {
            this.highlightJob.cancel();
        }
        if (ranges == null) {
            return;
        }
        final Pattern pattern = ranges.getWordPattern() != null ? Pattern.compile(ranges.getWordPattern()) : null;
        this.highlightJob = new UIJob("LSP4E Linked Editing"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                LinkedModeModel linkedModel = LSPLinkedEditingReconcilingStrategy.this.linkedModel = new LinkedModeModel();
                try {
                    linkedModel.addGroup(LSPLinkedEditingReconcilingStrategy.this.toJFaceGroup(ranges));
                    linkedModel.forceInstall();
                    ISourceViewer sourceViewer = NullSafetyHelper.castNonNull(LSPLinkedEditingReconcilingStrategy.this.sourceViewer);
                    ITextSelection selectionBefore = (ITextSelection)sourceViewer.getSelectionProvider().getSelection();
                    EditorLinkedModeUI linkedMode = new EditorLinkedModeUI(linkedModel, (ITextViewer)sourceViewer);
                    linkedMode.setExitPolicy((arg_0, arg_1, arg_2, arg_3) -> this.lambda$0(pattern, (LinkedModeUI)linkedMode, arg_0, arg_1, arg_2, arg_3));
                    linkedMode.enter();
                    sourceViewer.getSelectionProvider().setSelection((ISelection)selectionBefore);
                    return Status.OK_STATUS;
                }
                catch (BadLocationException ex) {
                    return new Status(4, "org.eclipse.lsp4e", ex.getMessage(), (Throwable)ex);
                }
            }

            private /* synthetic */ LinkedModeUI.ExitFlags lambda$0(Pattern pattern2, LinkedModeUI linkedModeUI, LinkedModeModel model, VerifyEvent event, int offset, int length) {
                Matcher matcher;
                String valuee;
                if (event.character == '\u0000' || event.character == '\b') {
                    return null;
                }
                if (pattern2 != null ? (valuee = LSPLinkedEditingReconcilingStrategy.this.getValueInRange(linkedModeUI.getSelectedRegion(), event, offset, length)) != null && (matcher = pattern2.matcher(valuee)).matches() : Character.isUnicodeIdentifierPart(event.character) || event.character == '_') {
                    return null;
                }
                return new LinkedModeUI.ExitFlags(1, true);
            }
        };
        this.highlightJob.schedule();
    }

    private @Nullable String getValueInRange(IRegion selectedRegion, VerifyEvent event, int offset, int length) {
        if (offset < selectedRegion.getOffset() || offset > selectedRegion.getOffset() + selectedRegion.getLength()) {
            return null;
        }
        try {
            StringBuilder sb = new StringBuilder(NullSafetyHelper.castNonNull(this.document).get(selectedRegion.getOffset(), selectedRegion.getLength()));
            String newChars = event.character == '\u0000' ? "" : Character.toString(event.character);
            sb.replace(offset - selectedRegion.getOffset(), offset - selectedRegion.getOffset() + selectedRegion.getLength(), newChars);
            return sb.toString();
        }
        catch (BadLocationException e) {
            LanguageServerPlugin.logError(e);
            return null;
        }
    }

    private LinkedPositionGroup toJFaceGroup(LinkedEditingRanges ranges) throws BadLocationException {
        IDocument document = NullSafetyHelper.castNonNull(this.document);
        LinkedPositionGroup res = new LinkedPositionGroup();
        for (Range range : ranges.getRanges()) {
            int startOffset = LSPEclipseUtils.toOffset(range.getStart(), document);
            int length = LSPEclipseUtils.toOffset(range.getEnd(), document) - startOffset;
            res.addPosition(new LinkedPosition(document, startOffset, length));
        }
        return res;
    }

    private final class EditorSelectionChangedListener
    implements ISelectionChangedListener {
        private EditorSelectionChangedListener() {
        }

        public void install(@Nullable ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(@Nullable ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            LSPLinkedEditingReconcilingStrategy.this.updateLinkedEditing(event.getSelection());
        }
    }
}

