/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.AbstractTracebackStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.traceback.TracebackCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestFactory;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.unusedEvaluation.UnusedEvaluationRequestSet;
import org.eclipse.ocl.examples.impactanalyzer.util.AnnotatedEObject;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.OperationCallExpKeyedSet;

public class BranchingTracebackStep<E extends OCLExpression>
extends AbstractTracebackStep<E> {
    private final Set<AbstractTracebackStep.TracebackStepAndScopeChange> steps = new HashSet<AbstractTracebackStep.TracebackStepAndScopeChange>();

    public BranchingTracebackStep(E sourceExpression, Stack<String> tupleLiteralNamesToLookFor, OppositeEndFinder oppositeEndFinder, OperationBodyToCallMapper operationBodyToCallMapper, UnusedEvaluationRequestFactory unusedEvaluationRequestFactory, OCLFactory oclFactory) {
        super(sourceExpression, tupleLiteralNamesToLookFor, oppositeEndFinder, operationBodyToCallMapper, unusedEvaluationRequestFactory, oclFactory);
    }

    @Override
    protected OperationCallExpKeyedSet performSubsequentTraceback(AnnotatedEObject source, UnusedEvaluationRequestSet pendingUnusedEvalRequests, TracebackCache tracebackCache, Notification changeEvent) {
        ArrayList<OperationCallExpKeyedSet> results = new ArrayList<OperationCallExpKeyedSet>(this.steps.size());
        int nonEmptyCount = 0;
        int singleNonEmptyIndex = -1;
        int i = 0;
        for (AbstractTracebackStep.TracebackStepAndScopeChange step : this.steps) {
            OperationCallExpKeyedSet next = step.traceback(this.annotateEObject(source), pendingUnusedEvalRequests, tracebackCache, changeEvent);
            if (nonEmptyCount <= 1 && !next.isEmpty()) {
                if (nonEmptyCount == 0) {
                    singleNonEmptyIndex = i;
                }
                ++nonEmptyCount;
            }
            if (next.isEmpty()) continue;
            results.add(next);
            ++i;
        }
        OperationCallExpKeyedSet result = nonEmptyCount == 0 ? tracebackCache.getOperationCallExpKeyedSetFactory().emptySet() : (nonEmptyCount == 1 ? (OperationCallExpKeyedSet)results.get(singleNonEmptyIndex) : tracebackCache.getOperationCallExpKeyedSetFactory().createOperationCallExpKeyedSet(results));
        return result;
    }

    protected Set<AbstractTracebackStep.TracebackStepAndScopeChange> getSteps() {
        return this.steps;
    }
}

