/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.core.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.internal.core.RSEInitJob;
import org.eclipse.rse.internal.core.model.ISystemProfileOperation;
import org.eclipse.rse.internal.core.model.SystemProfile;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;

public class SystemProfileManager
implements ISystemProfileManager {
    private List _profiles = new ArrayList(10);
    private static SystemProfileManager singleton = new SystemProfileManager();
    private boolean active = true;
    private ISystemProfile defaultProfile = null;

    private SystemProfileManager() {
    }

    public static SystemProfileManager getDefault() {
        return singleton;
    }

    public static void clearDefault() {
        singleton.forgetProfiles();
    }

    public static IStatus run(ISystemProfileOperation operation) {
        IStatus result = null;
        SystemProfileManager instance = SystemProfileManager.getDefault();
        result = instance.runOperation(operation);
        return result;
    }

    private IStatus runOperation(ISystemProfileOperation operation) {
        IStatus status = Status.OK_STATUS;
        boolean wasActive = this.active;
        this.active = false;
        try {
            status = operation.run();
        }
        finally {
            if (wasActive) {
                this.active = true;
                this.commitProfiles();
            }
        }
        return status;
    }

    private void commitProfiles() {
        Iterator z = this._profiles.iterator();
        while (z.hasNext()) {
            ISystemProfile profile = (ISystemProfile)z.next();
            profile.commit();
        }
    }

    public IStatus commitSystemProfile(ISystemProfile profile) {
        return this.commitSystemProfile(profile, false);
    }

    public IStatus commitSystemProfile(ISystemProfile profile, boolean immediate) {
        IStatus status = Status.OK_STATUS;
        boolean scheduled = false;
        if (this.active) {
            if (!RSECorePlugin.getThePersistenceManager().isBusy()) {
                scheduled = immediate ? RSECorePlugin.getThePersistenceManager().commitProfile(profile, 0L) : RSECorePlugin.getThePersistenceManager().commitProfile(profile, 5000L);
            }
        } else {
            scheduled = true;
        }
        if (!scheduled) {
            String pluginId = RSECorePlugin.getDefault().getBundle().getSymbolicName();
            int code = 1;
            status = new Status(1, pluginId, code, "", null);
        }
        return status;
    }

    public ISystemProfile createSystemProfile(String name, boolean makeActive) {
        ISystemProfile existingProfile = this.getSystemProfile(name);
        if (existingProfile != null) {
            existingProfile.suspend();
            this.deleteSystemProfile(existingProfile, false);
        }
        ISystemProfile newProfile = this.internalCreateSystemProfile(name);
        newProfile.setActive(makeActive);
        newProfile.commit();
        return newProfile;
    }

    public void makeSystemProfileActive(ISystemProfile profile, boolean makeActive) {
        profile.setActive(makeActive);
        profile.commit();
    }

    public ISystemProfile[] getSystemProfiles() {
        boolean restoring = !RSEInitJob.getInstance().isComplete(0);
        return this.getSystemProfiles(restoring);
    }

    public String[] getSystemProfileNames() {
        ISystemProfile[] profiles = this.getSystemProfiles();
        String[] profileNames = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            ISystemProfile profile = profiles[i];
            profileNames[i] = profile.getName();
            ++i;
        }
        return profileNames;
    }

    public ISystemProfile getSystemProfile(String name) {
        ISystemProfile result = null;
        Iterator z = this._profiles.iterator();
        while (z.hasNext()) {
            ISystemProfile p = (ISystemProfile)z.next();
            if (!p.getName().equals(name)) continue;
            result = p;
            break;
        }
        return result;
    }

    public void renameSystemProfile(ISystemProfile profile, String newName) {
        String oldName = profile.getName();
        profile.setName(newName);
        RSECorePlugin.getThePersistenceManager().commitProfile(profile, 5000L);
        RSECorePlugin.getThePersistenceManager().deleteProfile(profile.getPersistenceProvider(), oldName);
    }

    public void deleteSystemProfile(ISystemProfile profile, boolean persist) {
        if (profile != this.defaultProfile) {
            String oldName = profile.getName();
            boolean isActive = this.isSystemProfileActive(oldName);
            this._profiles.remove(profile);
            if (isActive) {
                RSEPreferencesManager.deleteActiveProfile(oldName);
            }
            if (persist) {
                IRSEPersistenceProvider provider = profile.getPersistenceProvider();
                RSECorePlugin.getThePersistenceManager().deleteProfile(provider, oldName);
            }
        }
    }

    public ISystemProfile cloneSystemProfile(ISystemProfile profile, String newName) {
        ISystemProfile newProfile = this.createSystemProfile(newName, false);
        return newProfile;
    }

    public boolean isSystemProfileActive(String profileName) {
        ISystemProfile profile = this.getSystemProfile(profileName);
        return profile.isActive();
    }

    public ISystemProfile[] getActiveSystemProfiles() {
        ArrayList<ISystemProfile> activeProfiles = new ArrayList<ISystemProfile>();
        Iterator z = this._profiles.iterator();
        while (z.hasNext()) {
            ISystemProfile p = (ISystemProfile)z.next();
            if (!p.isActive()) continue;
            activeProfiles.add(p);
        }
        ISystemProfile[] result = new ISystemProfile[activeProfiles.size()];
        activeProfiles.toArray(result);
        return result;
    }

    public String[] getActiveSystemProfileNames() {
        ISystemProfile[] profiles = this.getActiveSystemProfiles();
        String[] names = new String[profiles.length];
        int i = 0;
        while (i < profiles.length) {
            ISystemProfile systemProfile = profiles[i];
            names[i] = systemProfile.getName();
            ++i;
        }
        return names;
    }

    public ISystemProfile getDefaultPrivateSystemProfile() {
        this.ensureDefaultPrivateProfile();
        return this.defaultProfile;
    }

    public ISystemProfile getDefaultTeamSystemProfile() {
        this.ensureDefaultTeamProfile();
        ISystemProfile teamProfile = this.getSystemProfile(RSEPreferencesManager.getDefaultTeamProfileName());
        return teamProfile;
    }

    public int getSize() {
        return this._profiles.size();
    }

    public void addSystemProfile(ISystemProfile profile) {
        this._profiles.add(profile);
        profile.setProfileManager(this);
        String name = profile.getName();
        if (profile.isActive()) {
            RSEPreferencesManager.addActiveProfile(name);
        }
    }

    private void createDefaultPrivateProfile() {
        String initProfileName = RSEPreferencesManager.getDefaultPrivateSystemProfileName();
        ISystemProfile profile = this.internalCreateSystemProfile(initProfileName);
        profile.setDefaultPrivate(true);
        this.defaultProfile = profile;
    }

    private ISystemProfile internalCreateSystemProfile(String name) {
        SystemProfile profile = new SystemProfile();
        profile.setName(name);
        this.addSystemProfile(profile);
        return profile;
    }

    private void ensureDefaultPrivateProfile() {
        ISystemProfile profile;
        Iterator z;
        if (this.defaultProfile == null) {
            Iterator z2 = this._profiles.iterator();
            while (z2.hasNext() && this.defaultProfile == null) {
                ISystemProfile profile2 = (ISystemProfile)z2.next();
                if (!profile2.isDefaultPrivate()) continue;
                this.defaultProfile = profile2;
            }
        }
        if (this.defaultProfile == null) {
            String defaultPrivateProfileName = RSEPreferencesManager.getDefaultPrivateSystemProfileName();
            z = this._profiles.iterator();
            while (z.hasNext() && this.defaultProfile == null) {
                profile = (ISystemProfile)z.next();
                if (!profile.getName().equals(defaultPrivateProfileName)) continue;
                profile.setDefaultPrivate(true);
                this.defaultProfile = profile;
            }
        }
        if (this.defaultProfile == null) {
            String defaultTeamProfileName = RSEPreferencesManager.getDefaultTeamProfileName();
            z = this._profiles.iterator();
            while (z.hasNext() && this.defaultProfile == null) {
                profile = (ISystemProfile)z.next();
                if (profile.getName().equals(defaultTeamProfileName)) continue;
                profile.setDefaultPrivate(true);
                this.defaultProfile = profile;
            }
        }
        if (this.defaultProfile == null) {
            Logger logger = RSECorePlugin.getDefault().getLogger();
            logger.logWarning("Only one Profile Team exists - there is no Default Profile");
            this.createDefaultPrivateProfile();
        }
        this.defaultProfile.setActive(true);
    }

    private void forgetProfiles() {
        this._profiles.clear();
    }

    private void ensureDefaultTeamProfile() {
        String name = RSEPreferencesManager.getDefaultTeamProfileName();
        ISystemProfile teamProfile = this.getSystemProfile(name);
        if (teamProfile == null) {
            teamProfile = this.internalCreateSystemProfile(name);
        }
    }

    private ISystemProfile[] getSystemProfiles(boolean restoring) {
        if (!restoring) {
            this.ensureDefaultPrivateProfile();
        }
        ISystemProfile[] result = new ISystemProfile[this._profiles.size()];
        this._profiles.toArray(result);
        return result;
    }
}

