/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.log.TraceCompassLog;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.IntegerRangeCondition;
import org.eclipse.tracecompass.internal.provisional.datastore.core.condition.TimeRangeCondition;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.AttributeTree;
import org.eclipse.tracecompass.internal.statesystem.core.TransientState;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public class StateSystem
implements ITmfStateSystemBuilder {
    private static final int MAX_STACK_DEPTH = 100000;
    private static final String PARENT = "..";
    private static final String WILDCARD = "*";
    private static final @NonNull Logger LOGGER = TraceCompassLog.getLogger(StateSystem.class);
    private final AttributeTree attributeTree;
    private final TransientState transState;
    private final IStateHistoryBackend backend;
    private final CountDownLatch finishedLatch = new CountDownLatch(1);
    private boolean buildCancelled = false;
    private boolean isDisposed = false;

    public StateSystem(@NonNull IStateHistoryBackend backend) {
        this.backend = backend;
        this.transState = new TransientState(backend);
        this.attributeTree = new AttributeTree(this);
    }

    public StateSystem(@NonNull IStateHistoryBackend backend, boolean newFile) throws IOException {
        this.backend = backend;
        this.transState = new TransientState(backend);
        if (newFile) {
            this.attributeTree = new AttributeTree(this);
        } else {
            this.attributeTree = new AttributeTree(this, backend.supplyAttributeTreeReader());
            this.transState.setInactive();
            this.finishedLatch.countDown();
        }
    }

    @Override
    public String getSSID() {
        return this.backend.getSSID();
    }

    @Override
    public boolean isCancelled() {
        return this.buildCancelled;
    }

    @Override
    public void waitUntilBuilt() {
        try {
            this.finishedLatch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public boolean waitUntilBuilt(long timeout) {
        boolean ret = false;
        try {
            ret = this.finishedLatch.await(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ret;
    }

    @Override
    public synchronized void dispose() {
        this.isDisposed = true;
        if (this.transState.isActive()) {
            this.transState.setInactive();
            this.buildCancelled = true;
        }
        this.backend.dispose();
    }

    public AttributeTree getAttributeTree() {
        return this.attributeTree;
    }

    public void addEmptyAttribute() {
        this.transState.addEmptyEntry();
    }

    @Override
    public int getNbAttributes() {
        return this.getAttributeTree().getNbAttributes();
    }

    @Override
    public String getAttributeName(int attributeQuark) {
        return this.getAttributeTree().getAttributeName(attributeQuark);
    }

    @Override
    public String getFullAttributePath(int attributeQuark) {
        return this.getAttributeTree().getFullAttributeName(attributeQuark);
    }

    @Override
    public String[] getFullAttributePathArray(int attributeQuark) {
        return this.getAttributeTree().getFullAttributePathArray(attributeQuark);
    }

    @Override
    public long getStartTime() {
        return this.backend.getStartTime();
    }

    @Override
    public long getCurrentEndTime() {
        return this.backend.getEndTime();
    }

    @Override
    public void closeHistory(long endTime) throws TimeRangeException {
        long realEndTime = endTime;
        if (realEndTime < this.backend.getEndTime()) {
            realEndTime = this.backend.getEndTime();
        }
        this.transState.closeTransientState(realEndTime);
        this.backend.finishedBuilding(realEndTime);
        File attributeTreeFile = this.backend.supplyAttributeTreeWriterFile();
        long attributeTreeFilePos = this.backend.supplyAttributeTreeWriterFilePosition();
        if (attributeTreeFile != null) {
            this.getAttributeTree().writeSelf(attributeTreeFile, attributeTreeFilePos);
        }
        this.finishedLatch.countDown();
    }

    @Override
    public int getQuarkAbsolute(String ... attribute) throws AttributeNotFoundException {
        int quark = this.getAttributeTree().getQuarkDontAdd(-1, attribute);
        if (quark == -2) {
            throw new AttributeNotFoundException(this.getSSID() + " Path:" + Arrays.toString(attribute));
        }
        return quark;
    }

    @Override
    public int optQuarkAbsolute(String ... attribute) {
        return this.getAttributeTree().getQuarkDontAdd(-1, attribute);
    }

    @Override
    public int getQuarkAbsoluteAndAdd(String ... attribute) {
        return this.getAttributeTree().getQuarkAndAdd(-1, attribute);
    }

    @Override
    public int getQuarkRelative(int startingNodeQuark, String ... subPath) throws AttributeNotFoundException {
        int quark = this.getAttributeTree().getQuarkDontAdd(startingNodeQuark, subPath);
        if (quark == -2) {
            throw new AttributeNotFoundException(this.getSSID() + " Quark:" + startingNodeQuark + ", SubPath:" + Arrays.toString(subPath));
        }
        return quark;
    }

    @Override
    public int optQuarkRelative(int startingNodeQuark, String ... subPath) {
        return this.getAttributeTree().getQuarkDontAdd(startingNodeQuark, subPath);
    }

    @Override
    public int getQuarkRelativeAndAdd(int startingNodeQuark, String ... subPath) {
        return this.getAttributeTree().getQuarkAndAdd(startingNodeQuark, subPath);
    }

    @Override
    public List<@NonNull Integer> getSubAttributes(int quark, boolean recursive) {
        return this.getAttributeTree().getSubAttributes(quark, recursive);
    }

    @Override
    public List<@NonNull Integer> getSubAttributes(int quark, boolean recursive, String pattern) {
        List<@NonNull Integer> all = this.getSubAttributes(quark, recursive);
        LinkedList<@NonNull Integer> ret = new LinkedList<Integer>();
        Pattern regex = Pattern.compile(pattern, 40);
        for (Integer attQuark : all) {
            String name = this.getAttributeName(attQuark);
            if (!regex.matcher(name).matches()) continue;
            ret.add(attQuark);
        }
        return ret;
    }

    @Override
    public int getParentAttributeQuark(int quark) {
        return this.getAttributeTree().getParentAttributeQuark(quark);
    }

    @Override
    public List<@NonNull Integer> getQuarks(String ... pattern) {
        return this.getQuarks(-1, pattern);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public List<@NonNull Integer> getQuarks(int startingNodeQuark, String ... pattern) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull ImmutableSet.Builder builder = ImmutableSet.builder();
        if (pattern.length > 0) {
            this.getQuarks((ImmutableCollection.Builder<Integer>)builder, startingNodeQuark, Arrays.asList(pattern));
        } else {
            builder.add((Object)startingNodeQuark);
        }
        return builder.build().asList();
    }

    private void getQuarks(// Could not load outer class - annotation placement on inner may be incorrect
    ImmutableCollection.Builder<@NonNull Integer> builder, int quark, List<String> pattern) {
        String element = pattern.get(0);
        if (element == null) {
            return;
        }
        List<String> remainder = pattern.subList(1, pattern.size());
        if (remainder.isEmpty()) {
            if (element.equals(WILDCARD)) {
                builder.addAll(this.getSubAttributes(quark, false));
            } else if (element.equals(PARENT)) {
                builder.add((Object)this.getParentAttributeQuark(quark));
            } else {
                int subQuark = this.optQuarkRelative(quark, element);
                if (subQuark != -2) {
                    builder.add((Object)subQuark);
                }
            }
        } else if (element.equals(WILDCARD)) {
            this.getSubAttributes(quark, false).forEach(subquark -> this.getQuarks(builder, (int)subquark, remainder));
        } else if (element.equals(PARENT)) {
            this.getQuarks(builder, this.getParentAttributeQuark(quark), remainder);
        } else {
            int subQuark = this.optQuarkRelative(quark, element);
            if (subQuark != -2) {
                this.getQuarks(builder, subQuark, remainder);
            }
        }
    }

    @Override
    public void modifyAttribute(long t, Object value, int attributeQuark) throws TimeRangeException, StateValueTypeException {
        this.transState.processStateChange(t, value, attributeQuark);
    }

    @Override
    public void pushAttribute(long t, Object value, int attributeQuark) throws TimeRangeException, StateValueTypeException {
        int stackDepth;
        Object previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV == null) {
            stackDepth = 0;
        } else if (previousSV instanceof Integer) {
            stackDepth = (Integer)previousSV;
        } else {
            throw new StateValueTypeException(this.getSSID() + " Quark:" + attributeQuark + ", Type:" + String.valueOf(previousSV.getClass()) + ", Expected:" + String.valueOf((Object)ITmfStateValue.Type.INTEGER));
        }
        if (stackDepth >= 100000) {
            String message = " Stack limit reached, not pushing";
            throw new IllegalStateException(this.getSSID() + " Quark:" + attributeQuark + message);
        }
        int subAttributeQuark = this.getQuarkRelativeAndAdd(attributeQuark, String.valueOf(++stackDepth));
        this.modifyAttribute(t, stackDepth, attributeQuark);
        this.modifyAttribute(t, value, subAttributeQuark);
    }

    @Override
    public ITmfStateValue popAttribute(long t, int attributeQuark) throws TimeRangeException, StateValueTypeException {
        Object pop = this.popAttributeObject(t, attributeQuark);
        return pop != null ? TmfStateValue.newValue(pop) : null;
    }

    @Override
    public Object popAttributeObject(long t, int attributeQuark) throws TimeRangeException, StateValueTypeException {
        int subAttributeQuark;
        @Nullable Object previousSV = this.transState.getOngoingStateValue(attributeQuark);
        if (previousSV == null) {
            return null;
        }
        int stackDepth = 0;
        if (!(previousSV instanceof Integer)) {
            throw new StateValueTypeException(this.getSSID() + " Quark:" + attributeQuark + ", Stack depth:" + stackDepth);
        }
        stackDepth = (Integer)previousSV;
        try {
            subAttributeQuark = this.getQuarkRelative(attributeQuark, String.valueOf(stackDepth));
        }
        catch (AttributeNotFoundException e) {
            String message = " Stack attribute missing sub-attribute for depth:" + stackDepth;
            throw new IllegalStateException(this.getSSID() + " Quark:" + attributeQuark + message);
        }
        Object poppedValue = this.queryOngoing(subAttributeQuark);
        Integer nextSV = --stackDepth == 0 ? null : Integer.valueOf(stackDepth);
        this.modifyAttribute(t, nextSV, attributeQuark);
        this.removeAttribute(t, subAttributeQuark);
        return poppedValue;
    }

    @Override
    public void removeAttribute(long t, int attributeQuark) throws TimeRangeException {
        List<@NonNull Integer> childAttributes = this.getSubAttributes(attributeQuark, false);
        for (int childNodeQuark : childAttributes) {
            if (attributeQuark == childNodeQuark) {
                throw new IllegalStateException();
            }
            this.removeAttribute(t, childNodeQuark);
        }
        try {
            this.transState.processStateChange(t, null, attributeQuark);
        }
        catch (StateValueTypeException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ITmfStateValue queryOngoingState(int attributeQuark) {
        return TmfStateValue.newValue(this.queryOngoing(attributeQuark));
    }

    @Override
    public Object queryOngoing(int attributeQuark) {
        return this.transState.getOngoingStateValue(attributeQuark);
    }

    @Override
    public List<@Nullable Object> queryOngoing() {
        return this.transState.getOngoingStateValues();
    }

    @Override
    public long getOngoingStartTime(int attribute) {
        return this.transState.getOngoingStartTime(attribute);
    }

    @Override
    public void updateOngoingState(ITmfStateValue newValue, int attributeQuark) {
        this.transState.changeOngoingStateValue(attributeQuark, newValue.unboxValue());
    }

    @Override
    public void updateOngoingState(Object newValue, int attributeQuark) {
        this.transState.changeOngoingStateValue(attributeQuark, newValue);
    }

    protected void replaceOngoingState(@NonNull List<@NonNull ITmfStateInterval> newStateIntervals) {
        this.transState.replaceOngoingState(newStateIntervals);
    }

    @Override
    public List<ITmfStateInterval> queryFullState(long t) throws TimeRangeException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        Throwable throwable = null;
        Object var4_4 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "StateSystem:FullQuery", new Object[]{"ssid", this.getSSID(), "ts", t});){
            int nbAttr = this.getNbAttributes();
            ArrayList<@Nullable ITmfStateInterval> stateInfo = new ArrayList<ITmfStateInterval>(nbAttr);
            int i = 0;
            while (i < nbAttr) {
                stateInfo.add(null);
                ++i;
            }
            if (this.transState.isActive()) {
                this.transState.doQuery(stateInfo, t);
            }
            this.backend.doQuery(stateInfo, t);
            for (ITmfStateInterval interval : stateInfo) {
                if (interval != null) continue;
                throw new IllegalStateException("Incoherent interval storage");
            }
            return stateInfo;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public ITmfStateInterval querySingleState(long t, int attributeQuark) throws TimeRangeException, StateSystemDisposedException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        Throwable throwable = null;
        Object var5_5 = null;
        try (TraceCompassLogUtils.ScopeLog log = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINER, "StateSystem:SingleQuery", new Object[]{"ssid", this.getSSID(), "ts", t, "attribute", attributeQuark});){
            ITmfStateInterval ret = this.transState.getIntervalAt(t, attributeQuark);
            if (ret == null) {
                ret = this.backend.doSingularQuery(t, attributeQuark);
            }
            if (ret == null) {
                throw new IllegalStateException("Incoherent interval storage");
            }
            return ret;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(Collection<@NonNull Integer> quarks, Collection<@NonNull Long> times) throws StateSystemDisposedException, TimeRangeException, IndexOutOfBoundsException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        if (times.isEmpty()) {
            return Collections.emptyList();
        }
        TimeRangeCondition timeCondition = TimeRangeCondition.forDiscreteRange(times);
        return this.query2D(quarks, timeCondition, false);
    }

    @Override
    public Iterable<@NonNull ITmfStateInterval> query2D(Collection<@NonNull Integer> quarks, long start, long end) throws StateSystemDisposedException, TimeRangeException, IndexOutOfBoundsException {
        if (this.isDisposed) {
            throw new StateSystemDisposedException();
        }
        boolean reverse = start > end;
        TimeRangeCondition timeCondition = TimeRangeCondition.forContinuousRange((long)Math.min(start, end), (long)Math.max(start, end));
        return this.query2D(quarks, timeCondition, reverse);
    }

    private Iterable<@NonNull ITmfStateInterval> query2D(@NonNull Collection<@NonNull Integer> quarks, TimeRangeCondition timeCondition, boolean reverse) throws TimeRangeException, IndexOutOfBoundsException {
        if (timeCondition.min() < this.getStartTime()) {
            throw new TimeRangeException("Time conditions " + timeCondition.min() + " is lower than state system start time: " + this.getStartTime());
        }
        if (quarks.isEmpty()) {
            return Collections.emptyList();
        }
        IntegerRangeCondition quarkCondition = IntegerRangeCondition.forDiscreteRange(quarks);
        if (quarkCondition.min() < 0 || quarkCondition.max() >= this.getNbAttributes()) {
            throw new IndexOutOfBoundsException();
        }
        Iterable<@NonNull ITmfStateInterval> transStateIterable = this.transState.query2D(quarks, timeCondition);
        Iterable<@NonNull ITmfStateInterval> backendIterable = this.backend.query2D(quarkCondition, timeCondition, reverse);
        return Iterables.concat(transStateIterable, backendIterable);
    }

    @Override
    public void removeFiles() {
        this.backend.removeFiles();
    }

    static void logMissingInterval(int attribute, long timestamp) {
        Activator.getDefault().logInfo("No data found in history for attribute " + attribute + " at time " + timestamp + ", returning dummy interval");
    }
}

