/**
 * Copyright (c) 2010-2018, Zoltan Ujhelyi, Istvan Rath, Daniel Varro, IncQuery Labs Ltd.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-v20.html.
 *  * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.viatra.query.patternlanguage.emf.vql.impl;

import org.eclipse.emf.common.notify.Notification;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.viatra.query.patternlanguage.emf.vql.JavaConstantValue;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PatternLanguagePackage;

import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmField;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Java Constant Value</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaConstantValueImpl#getClassRef <em>Class Ref</em>}</li>
 *   <li>{@link org.eclipse.viatra.query.patternlanguage.emf.vql.impl.JavaConstantValueImpl#getFieldRef <em>Field Ref</em>}</li>
 * </ul>
 *
 * @generated
 */
public class JavaConstantValueImpl extends ValueReferenceImpl implements JavaConstantValue
{
	/**
	 * The cached value of the '{@link #getClassRef() <em>Class Ref</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getClassRef()
	 * @generated
	 * @ordered
	 */
	protected JvmDeclaredType classRef;

	/**
	 * The cached value of the '{@link #getFieldRef() <em>Field Ref</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFieldRef()
	 * @generated
	 * @ordered
	 */
	protected JvmField fieldRef;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected JavaConstantValueImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return PatternLanguagePackage.Literals.JAVA_CONSTANT_VALUE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JvmDeclaredType getClassRef()
	{
		if (classRef != null && classRef.eIsProxy())
		{
			InternalEObject oldClassRef = (InternalEObject)classRef;
			classRef = (JvmDeclaredType)eResolveProxy(oldClassRef);
			if (classRef != oldClassRef)
			{
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, PatternLanguagePackage.JAVA_CONSTANT_VALUE__CLASS_REF, oldClassRef, classRef));
			}
		}
		return classRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmDeclaredType basicGetClassRef()
	{
		return classRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setClassRef(JvmDeclaredType newClassRef)
	{
		JvmDeclaredType oldClassRef = classRef;
		classRef = newClassRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.JAVA_CONSTANT_VALUE__CLASS_REF, oldClassRef, classRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public JvmField getFieldRef()
	{
		if (fieldRef != null && fieldRef.eIsProxy())
		{
			InternalEObject oldFieldRef = (InternalEObject)fieldRef;
			fieldRef = (JvmField)eResolveProxy(oldFieldRef);
			if (fieldRef != oldFieldRef)
			{
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, PatternLanguagePackage.JAVA_CONSTANT_VALUE__FIELD_REF, oldFieldRef, fieldRef));
			}
		}
		return fieldRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmField basicGetFieldRef()
	{
		return fieldRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setFieldRef(JvmField newFieldRef)
	{
		JvmField oldFieldRef = fieldRef;
		fieldRef = newFieldRef;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, PatternLanguagePackage.JAVA_CONSTANT_VALUE__FIELD_REF, oldFieldRef, fieldRef));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__CLASS_REF:
				if (resolve) return getClassRef();
				return basicGetClassRef();
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__FIELD_REF:
				if (resolve) return getFieldRef();
				return basicGetFieldRef();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__CLASS_REF:
				setClassRef((JvmDeclaredType)newValue);
				return;
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__FIELD_REF:
				setFieldRef((JvmField)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__CLASS_REF:
				setClassRef((JvmDeclaredType)null);
				return;
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__FIELD_REF:
				setFieldRef((JvmField)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__CLASS_REF:
				return classRef != null;
			case PatternLanguagePackage.JAVA_CONSTANT_VALUE__FIELD_REF:
				return fieldRef != null;
		}
		return super.eIsSet(featureID);
	}

} //JavaConstantValueImpl
