/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.repositoryholders;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import org.openrdf.OpenRDFException;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.savetriggers.ISaveTrigger;

public abstract class AbstractSesameRepositoryHolder<T> {
    protected LoadingCache<T, Repository> repositories = CacheBuilder.newBuilder().build((CacheLoader)new InitRepositoryCallable());
    protected final LoadingCache<T, ThreadLocal<RepositoryConnection>> connections = CacheBuilder.newBuilder().build((CacheLoader)new ThreadLocalConnectionsBuilderCallable());

    public Repository getRepository(T project) throws ExecutionException {
        return (Repository)this.repositories.get(project);
    }

    public RepositoryConnection getConnection(T project) throws RepositoryException, ExecutionException {
        ThreadLocal connectionsThreadLocal = (ThreadLocal)this.connections.get(project);
        RepositoryConnection connection = (RepositoryConnection)connectionsThreadLocal.get();
        if (connection == null || !connection.isOpen()) {
            Repository repository = this.getRepository(project);
            connection = repository.getConnection();
            connectionsThreadLocal.set(connection);
        }
        return connection;
    }

    protected abstract Repository initRepository(T var1) throws IOException, OpenRDFException;

    public abstract ISaveTrigger getSaveTrigger(T var1) throws RepositoryException;

    private final class InitRepositoryCallable
    extends CacheLoader<T, Repository> {
        private InitRepositoryCallable() {
        }

        public Repository load(T key) throws IOException, OpenRDFException {
            return AbstractSesameRepositoryHolder.this.initRepository(key);
        }
    }

    private final class ThreadLocalConnectionsBuilderCallable
    extends CacheLoader<T, ThreadLocal<RepositoryConnection>> {
        private ThreadLocalConnectionsBuilderCallable() {
        }

        public ThreadLocal<RepositoryConnection> load(T key) {
            return new ThreadLocal<RepositoryConnection>();
        }
    }
}

