/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.utils;

import java.util.HashMap;
import java.util.Map;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;

public class SPARQLStringBuilder {
    private Map<String, String> namespaces = new HashMap<String, String>();
    private StringBuilder _builder;

    public SPARQLStringBuilder(StringBuilder builder) {
        this._builder = builder;
    }

    public int length() {
        return this._builder.length();
    }

    public int capacity() {
        return this._builder.capacity();
    }

    public int hashCode() {
        return this._builder.hashCode();
    }

    public void ensureCapacity(int minimumCapacity) {
        this._builder.ensureCapacity(minimumCapacity);
    }

    public void trimToSize() {
        this._builder.trimToSize();
    }

    public boolean equals(Object obj) {
        return this._builder.equals(obj);
    }

    public void setLength(int newLength) {
        this._builder.setLength(newLength);
    }

    public StringBuilder append(Object obj) {
        return this._builder.append(obj);
    }

    public StringBuilder append(String str) {
        return this._builder.append(str);
    }

    public StringBuilder append(StringBuffer sb) {
        return this._builder.append(sb);
    }

    public char charAt(int index) {
        return this._builder.charAt(index);
    }

    public StringBuilder append(CharSequence s) {
        return this._builder.append(s);
    }

    public StringBuilder append(CharSequence s, int start, int end) {
        return this._builder.append(s, start, end);
    }

    public int codePointAt(int index) {
        return this._builder.codePointAt(index);
    }

    public StringBuilder append(char[] str) {
        return this._builder.append(str);
    }

    public StringBuilder append(char[] str, int offset, int len) {
        return this._builder.append(str, offset, len);
    }

    public StringBuilder append(boolean b) {
        return this._builder.append(b);
    }

    public StringBuilder append(char c) {
        return this._builder.append(c);
    }

    public StringBuilder append(int i) {
        return this._builder.append(i);
    }

    public StringBuilder append(long lng) {
        return this._builder.append(lng);
    }

    public StringBuilder append(float f) {
        return this._builder.append(f);
    }

    public StringBuilder append(double d) {
        return this._builder.append(d);
    }

    public StringBuilder appendCodePoint(int codePoint) {
        return this._builder.appendCodePoint(codePoint);
    }

    public StringBuilder delete(int start, int end) {
        return this._builder.delete(start, end);
    }

    public int codePointBefore(int index) {
        return this._builder.codePointBefore(index);
    }

    public StringBuilder deleteCharAt(int index) {
        return this._builder.deleteCharAt(index);
    }

    public StringBuilder replace(int start, int end, String str) {
        return this._builder.replace(start, end, str);
    }

    public StringBuilder insert(int index, char[] str, int offset, int len) {
        return this._builder.insert(index, str, offset, len);
    }

    public StringBuilder insert(int offset, Object obj) {
        return this._builder.insert(offset, obj);
    }

    public StringBuilder insert(int offset, String str) {
        return this._builder.insert(offset, str);
    }

    public StringBuilder insert(int offset, char[] str) {
        return this._builder.insert(offset, str);
    }

    public StringBuilder insert(int dstOffset, CharSequence s) {
        return this._builder.insert(dstOffset, s);
    }

    public int codePointCount(int beginIndex, int endIndex) {
        return this._builder.codePointCount(beginIndex, endIndex);
    }

    public StringBuilder insert(int dstOffset, CharSequence s, int start, int end) {
        return this._builder.insert(dstOffset, s, start, end);
    }

    public StringBuilder insert(int offset, boolean b) {
        return this._builder.insert(offset, b);
    }

    public StringBuilder insert(int offset, char c) {
        return this._builder.insert(offset, c);
    }

    public StringBuilder insert(int offset, int i) {
        return this._builder.insert(offset, i);
    }

    public StringBuilder insert(int offset, long l) {
        return this._builder.insert(offset, l);
    }

    public int offsetByCodePoints(int index, int codePointOffset) {
        return this._builder.offsetByCodePoints(index, codePointOffset);
    }

    public StringBuilder insert(int offset, float f) {
        return this._builder.insert(offset, f);
    }

    public StringBuilder insert(int offset, double d) {
        return this._builder.insert(offset, d);
    }

    public int indexOf(String str) {
        return this._builder.indexOf(str);
    }

    public int indexOf(String str, int fromIndex) {
        return this._builder.indexOf(str, fromIndex);
    }

    public int lastIndexOf(String str) {
        return this._builder.lastIndexOf(str);
    }

    public int lastIndexOf(String str, int fromIndex) {
        return this._builder.lastIndexOf(str, fromIndex);
    }

    public StringBuilder reverse() {
        return this._builder.reverse();
    }

    public void getChars(int srcBegin, int srcEnd, char[] dst, int dstBegin) {
        this._builder.getChars(srcBegin, srcEnd, dst, dstBegin);
    }

    public void setCharAt(int index, char ch) {
        this._builder.setCharAt(index, ch);
    }

    public String substring(int start) {
        return this._builder.substring(start);
    }

    public CharSequence subSequence(int start, int end) {
        return this._builder.subSequence(start, end);
    }

    public String substring(int start, int end) {
        return this._builder.substring(start, end);
    }

    public SPARQLStringBuilder prefix(Namespace ns) {
        this.namespaces.put(ns.getName(), ns.getPrefix());
        this._builder.append("PREFIX ").append(ns.getPrefix()).append(": <").append(ns.getName()).append("> ");
        return this;
    }

    public SPARQLStringBuilder from(Resource context) {
        this._builder.append("FROM <").append(context.stringValue()).append("> ");
        return this;
    }

    public SPARQLStringBuilder select(String ... tokens) {
        this._builder.append("SELECT ");
        String[] stringArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            this._builder.append(" ?").append(token);
            ++n2;
        }
        this._builder.append(" ");
        return this;
    }

    public SPARQLStringBuilder uri(URI aUri) {
        String namespace = aUri.getNamespace();
        String nsname = this.namespaces.get(namespace);
        if (nsname != null && nsname.length() > 0) {
            this._builder.append(nsname).append(':').append(aUri.getLocalName());
        } else {
            this._builder.append('<').append(aUri.stringValue()).append('>');
        }
        return this;
    }

    public SPARQLStringBuilder token(String name) {
        this._builder.append('?').append(name);
        return this;
    }

    public SPARQLStringBuilder statement(URI val1, URI val2, URI val3) {
        this.uri(val1);
        this.append(' ');
        this.uri(val2);
        this.append(' ');
        this.uri(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(String val1, URI val2, URI val3) {
        this.token(val1);
        this.append(' ');
        this.uri(val2);
        this.append(' ');
        this.uri(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(String val1, String val2, URI val3) {
        this.token(val1);
        this.append(' ');
        this.token(val2);
        this.append(' ');
        this.uri(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(String val1, URI val2, String val3) {
        this.token(val1);
        this.append(' ');
        this.uri(val2);
        this.append(' ');
        this.token(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(URI val1, String val2, URI val3) {
        this.uri(val1);
        this.append(' ');
        this.token(val2);
        this.append(' ');
        this.uri(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(URI val1, String val2, String val3) {
        this.uri(val1);
        this.append(' ');
        this.token(val2);
        this.append(' ');
        this.token(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(URI val1, URI val2, String val3) {
        this.uri(val1);
        this.append(' ');
        this.uri(val2);
        this.append(' ');
        this.token(val3);
        this.append(" . ");
        return this;
    }

    public SPARQLStringBuilder statement(String val1, String val2, String val3) {
        this.token(val1);
        this.append(' ');
        this.token(val2);
        this.append(' ');
        this.token(val3);
        this.append(" . ");
        return this;
    }

    public String toString() {
        return this._builder.toString();
    }
}

