/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.dnd;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.part.IDropActionDelegate;
import org.polarsys.reqcycle.commands.Command;
import org.polarsys.reqcycle.commands.CreateRelationCommand;
import org.polarsys.reqcycle.commands.utils.RelationCommandUtils;
import org.polarsys.reqcycle.commands.utils.RelationCreationDescriptor;
import org.polarsys.reqcycle.dnd.DNDReqCycle;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.IconRegistry;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.provider.TypeconfigurationItemProviderAdapterFactory;
import org.polarsys.reqcycle.types.ITypesManager;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DropRequirementDelegate
implements IDropActionDelegate {
    IReachableCreator creator = (IReachableCreator)ZigguratInject.make(IReachableCreator.class);
    IReachableManager manager = (IReachableManager)ZigguratInject.make(IReachableManager.class);
    ITypesManager typesManager = (ITypesManager)ZigguratInject.make(ITypesManager.class);
    ITypesConfigurationProvider configManager = (ITypesConfigurationProvider)ZigguratInject.make(ITypesConfigurationProvider.class);

    public boolean run(Object source, Object target) {
        EObject targetEObj;
        IFile file;
        Reachable targetReachable = null;
        if (source instanceof byte[] && this.isEObject(target) && (file = WorkspaceSynchronizer.getFile((Resource)(targetEObj = this.getEObject(target)).eResource())) != null) {
            try {
                targetReachable = this.manager.getHandlerFromObject((Object)targetEObj).getFromObject((Object)targetEObj).getReachable();
                if (targetReachable != null) {
                    byte[] data = (byte[])source;
                    List<Reachable> reachables = DNDReqCycle.getReachables(data);
                    this.handleDrop(reachables, targetReachable, (IResource)file);
                }
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private boolean isEObject(Object target) {
        return this.getEObject(target) != null;
    }

    private EObject getEObject(Object target) {
        EObject result = null;
        if (target instanceof IAdaptable) {
            IAdaptable adaptable = (IAdaptable)target;
            result = (EObject)adaptable.getAdapter(EObject.class);
        }
        if (result == null) {
            result = (EObject)Platform.getAdapterManager().getAdapter(target, EObject.class);
        }
        if (result == null && result instanceof EObject) {
            result = (EObject)target;
        }
        return result;
    }

    public void handleDrop(List<Reachable> sourceReachables, Reachable targetReachable, IResource res) {
        Iterator<RelationCreationDescriptor> iteratorDU;
        Set allCommands = RelationCommandUtils.getAllRelationCommands(sourceReachables, Collections.singletonList(targetReachable));
        Iterable upstreamToDownstreams = Iterables.filter((Iterable)allCommands, (Predicate)new Predicate<RelationCreationDescriptor>(){

            public boolean apply(RelationCreationDescriptor desc) {
                return desc.isUpstreamToDownstream();
            }
        });
        Iterable downstreamToUpstream = Iterables.filter((Iterable)allCommands, (Predicate)new Predicate<RelationCreationDescriptor>(){

            public boolean apply(RelationCreationDescriptor desc) {
                return desc.isDownstreamToUpstream();
            }
        });
        Menu menu = new Menu((Control)Display.getDefault().getActiveShell());
        Iterator<RelationCreationDescriptor> iteratorUD = upstreamToDownstreams.iterator();
        if (iteratorUD.hasNext()) {
            DropRequirementDelegate.createMenu(menu, "Up To Down", iteratorUD, sourceReachables, targetReachable, 1);
        }
        if ((iteratorDU = downstreamToUpstream.iterator()).hasNext()) {
            DropRequirementDelegate.createMenu(menu, "Down To Up", iteratorDU, sourceReachables, targetReachable, -1);
        }
        menu.setVisible(true);
    }

    public static void createMenu(Menu menu, String string, Iterator<RelationCreationDescriptor> iteratorUD, List<Reachable> sourceReachables, Reachable targetReachable, int direction) {
        MenuItem newItem = new MenuItem(menu, 64);
        Menu newMenu = new Menu(menu);
        newItem.setMenu(newMenu);
        newItem.setText(string);
        while (iteratorUD.hasNext()) {
            RelationCreationDescriptor desc = iteratorUD.next();
            MenuItem item = new MenuItem(newMenu, 0);
            final ArrayList commands = Lists.newArrayList();
            for (Reachable source : sourceReachables) {
                CreateRelationCommand createRelationCommand = null;
                createRelationCommand = direction == -1 ? new CreateRelationCommand(desc.getRelation(), source, targetReachable) : new CreateRelationCommand(desc.getRelation(), targetReachable, source);
                ZigguratInject.inject((Object[])new Object[]{createRelationCommand});
                commands.add(createRelationCommand);
            }
            item.setText(desc.getLabel());
            if (desc.getRelation().getIcon() != null && desc.getRelation().getIcon().length() > 0) {
                item.setImage(IconRegistry.getImage((String)desc.getRelation().getIcon()));
            } else {
                item.setImage(new AdapterFactoryLabelProvider((AdapterFactory)new TypeconfigurationItemProviderAdapterFactory()).getImage((Object)desc.getRelation()));
            }
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    for (Command c : commands) {
                        c.execute();
                    }
                }
            });
        }
    }
}

