/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.cache.emfbased.functions;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.UUID;
import javax.inject.Inject;
import org.polarsys.reqcycle.traceability.cache.emfbased.functions.TraceableElement2Traceable;
import org.polarsys.reqcycle.traceability.cache.emfbased.model.CacheTracability.TraceabilityLink;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityLink2Link
implements Function<TraceabilityLink, Link> {
    @Inject
    IReachableCreator creator;

    public Link apply(TraceabilityLink aLink) {
        TraceableElement2Traceable traceableElement2Traceable = new TraceableElement2Traceable();
        ZigguratInject.inject((Object[])new Object[]{traceableElement2Traceable});
        Iterable sources = Iterables.transform(aLink.getSources(), (Function)traceableElement2Traceable);
        Iterable targets = Iterables.transform(aLink.getTargets(), (Function)traceableElement2Traceable);
        UUID uniqueID = UUID.randomUUID();
        URI uri = null;
        try {
            uri = new URI(aLink.getResource().getUri());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        Reachable r = this.creator.getReachable(uri);
        Link link = new Link(r, new TType(uniqueID.toString(), aLink.getLabel()), sources, targets);
        return link;
    }
}

