/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.operations.dialogs;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.reqcycle.operations.IParameter;
import org.polarsys.reqcycle.ui.eattrpropseditor.GenericEAttrPropsEditor;

public class OperationAttributesEditor
extends TitleAreaDialog {
    private final Map<String, GenericEAttrPropsEditor> editors;
    private Method method;

    public OperationAttributesEditor(Shell shell, Method method) {
        super(shell);
        this.setShellStyle(1168);
        this.method = method;
        this.editors = new LinkedHashMap<String, GenericEAttrPropsEditor>();
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Enter parameters");
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, true));
        top.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        ScrolledComposite scrolledComposite = new ScrolledComposite(top, 2560);
        scrolledComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        Composite c = new Composite((Composite)scrolledComposite, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setContent((Control)c);
        Class<?>[] paramList = this.method.getParameterTypes();
        if (paramList.length > 1) {
            int i = 1;
            while (i < paramList.length) {
                Class<?> paramClass = paramList[i];
                Annotation[] annotations = this.method.getParameterAnnotations()[i];
                String paramName = null;
                Annotation[] annotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    Annotation a = annotationArray[n2];
                    if (a instanceof IParameter) {
                        paramName = ((IParameter)a).value();
                        break;
                    }
                    ++n2;
                }
                if (paramName == null) {
                    paramName = "Parameter " + i;
                }
                paramName = String.valueOf(paramName) + " (" + paramClass.getSimpleName() + ")";
                this.addEditor(paramClass, paramName, c);
                ++i;
            }
        }
        scrolledComposite.setMinSize(c.computeSize(-1, -1));
        return top;
    }

    public void addEditor(Class<?> c, String attName, Composite composite) {
        GenericEAttrPropsEditor attributeEditor = new GenericEAttrPropsEditor(composite, 0);
        attributeEditor.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        List possibleValues = Collections.emptyList();
        attributeEditor.init(attName, c, possibleValues);
        this.editors.put(attName, attributeEditor);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            Iterator<Map.Entry<String, GenericEAttrPropsEditor>> entries = this.editors.entrySet().iterator();
            while (entries.hasNext()) {
                GenericEAttrPropsEditor editor = entries.next().getValue();
                if (editor.isEditionValid()) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Some values are not entered or not valid");
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    public Map<String, GenericEAttrPropsEditor> getEditors() {
        return this.editors;
    }
}

