/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs;

import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Attribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.AttributeType;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.StdAttribute;

public class AttributeComposite
extends Composite {
    private boolean editable;
    private Text textName;
    private Button buttonAdd;
    private Combo comboType;
    private List listValuess;
    private ComboViewer comboViewer;
    private Collection<String> allPossibleValues = new LinkedList<String>();
    private Button btnRemove;
    private ListViewer listViewer;

    public AttributeComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblName = new Label((Composite)this, 0);
        lblName.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblName.setText("name : ");
        new Label((Composite)this, 0);
        this.textName = new Text((Composite)this, 2048);
        this.textName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblType = new Label((Composite)this, 0);
        lblType.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblType.setText("type : ");
        new Label((Composite)this, 0);
        this.comboViewer = new ComboViewer((Composite)this, 8);
        this.comboType = this.comboViewer.getCombo();
        this.comboType.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AttributeType) {
                    AttributeType type = (AttributeType)element;
                    return type.getName();
                }
                return super.getText(element);
            }
        });
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setInput((Object)AttributeType.values());
        Label lblPossibleValues = new Label((Composite)this, 0);
        lblPossibleValues.setText("Possible Values : ");
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.listViewer = new ListViewer(composite, 2560);
        this.listValuess = this.listViewer.getList();
        this.listValuess.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.listViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.listViewer.setInput(this.allPossibleValues);
        Composite composite_1 = new Composite(composite, 0);
        composite_1.setLayoutData((Object)new GridData(131072, 128, false, false, 1, 1));
        composite_1.setLayout((Layout)new FillLayout(512));
        composite_1.setBounds(0, 0, 64, 64);
        this.buttonAdd = new Button(composite_1, 0);
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog dialog = new InputDialog(AttributeComposite.this.getShell(), "Value", "Please enter a possible value", "", null);
                if (dialog.open() == 0) {
                    AttributeComposite.this.allPossibleValues.add(dialog.getValue());
                    AttributeComposite.this.listViewer.refresh();
                }
            }
        });
        this.buttonAdd.setText("Add");
        this.btnRemove = new Button(composite_1, 0);
        this.btnRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = AttributeComposite.this.listViewer.getSelection();
                if (selection != null) {
                    String element = (String)((IStructuredSelection)selection).getFirstElement();
                    AttributeComposite.this.allPossibleValues.remove(element);
                    AttributeComposite.this.listViewer.refresh();
                }
            }
        });
        this.btnRemove.setText("Remove");
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        this.textName.setEnabled(editable);
        this.btnRemove.setEnabled(editable);
        this.buttonAdd.setEnabled(editable);
        this.comboType.setEnabled(editable);
        this.textName.setText("");
        this.comboType.clearSelection();
        this.allPossibleValues.clear();
        this.listViewer.refresh();
        this.comboViewer.setSelection(null);
    }

    public boolean isValid() {
        if (this.editable) {
            return this.textName != null && !this.comboViewer.getSelection().isEmpty();
        }
        return true;
    }

    public void displayAttribute(Attribute att) {
        this.textName.setText(att.getName());
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)att.getType()));
        this.allPossibleValues.addAll((Collection<String>)att.getPossibleValues());
        this.comboViewer.refresh(true);
        this.listViewer.refresh();
    }

    public void saveInAttribute(StdAttribute att) {
        att.setName(this.textName.getText());
        att.setType((AttributeType)((IStructuredSelection)this.comboViewer.getSelection()).getFirstElement());
        att.getPossibleValues().addAll(this.allPossibleValues);
    }
}

