/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.modelnature.internal;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.polarsys.reqcycle.utils.modelnature.ModelNature;
import org.polarsys.reqcycle.utils.modelnature.ModelNatureService;
import org.polarsys.reqcycle.utils.modelnature.exceptions.NatureNotFoundException;

@Singleton
public class SerializedNatureServiceImpl
implements ModelNatureService {
    private static final String MODEL_NATURE_EXTENSION_POINT_ID = "org.polarsys.reqcycle.utils.modelnature.modelnature";
    protected static final String SEPARATOR = ";";
    protected static final String NATURE_ANNOTATION_KEY = "MODEL_NATURES";
    protected static final String NATURE_SOURCE_URI = "http://www.agesys.org/nature";
    private Map<String, ModelNature> natures = null;

    @Override
    public void addNature(final EModelElement eObject, String natureID) throws NatureNotFoundException {
        if (this.hasNature(eObject, natureID)) {
            return;
        }
        if (!this.getModelNaturesIds().contains(natureID)) {
            throw new NatureNotFoundException(natureID);
        }
        String[] natures = this.getNatures(eObject);
        ArrayList newNatures = Lists.newArrayList();
        newNatures.addAll(Arrays.asList(natures));
        newNatures.add(natureID);
        final String newNaturesAsString = this.naturesAsString(newNatures);
        this.safeExecute((Command)new AbstractCommand(){

            public void execute() {
                EcoreUtil.setAnnotation((EModelElement)eObject, (String)SerializedNatureServiceImpl.NATURE_SOURCE_URI, (String)SerializedNatureServiceImpl.NATURE_ANNOTATION_KEY, (String)newNaturesAsString);
            }

            public void redo() {
            }
        }, TransactionUtil.getEditingDomain((EObject)eObject));
    }

    @Override
    public void removeNature(final EModelElement eObject, String natureID) throws NatureNotFoundException {
        if (!this.getModelNaturesIds().contains(natureID)) {
            throw new NatureNotFoundException(natureID);
        }
        String[] natures = this.getNatures(eObject);
        ArrayList newNatures = Lists.newArrayList();
        newNatures.addAll(Arrays.asList(natures));
        newNatures.remove(natureID);
        final String newNaturesAsString = this.naturesAsString(newNatures);
        this.safeExecute((Command)new AbstractCommand(){

            public void execute() {
                if (newNaturesAsString.isEmpty()) {
                    EcoreUtil.setAnnotation((EModelElement)eObject, (String)SerializedNatureServiceImpl.NATURE_SOURCE_URI, (String)SerializedNatureServiceImpl.NATURE_ANNOTATION_KEY, null);
                } else {
                    EcoreUtil.setAnnotation((EModelElement)eObject, (String)SerializedNatureServiceImpl.NATURE_SOURCE_URI, (String)SerializedNatureServiceImpl.NATURE_ANNOTATION_KEY, (String)newNaturesAsString);
                }
            }

            public void redo() {
            }
        }, TransactionUtil.getEditingDomain((EObject)eObject));
    }

    @Override
    public boolean hasNature(EModelElement eObject, String natureID) {
        if (!this.getModelNaturesIds().contains(natureID)) {
            return false;
        }
        String[] natures = this.getNatures(eObject);
        List<String> naturesAsList = Arrays.asList(natures);
        return naturesAsList.contains(natureID);
    }

    protected String[] getNatures(EModelElement eObject) {
        String annotation = EcoreUtil.getAnnotation((EModelElement)eObject, (String)NATURE_SOURCE_URI, (String)NATURE_ANNOTATION_KEY);
        if (annotation != null) {
            String[] naturesAsArray = annotation.split(SEPARATOR);
            return naturesAsArray;
        }
        return new String[0];
    }

    protected String naturesAsString(List<String> natures) {
        StringBuilder builder = new StringBuilder();
        if (natures.size() > 0) {
            int i = 0;
            while (i < natures.size()) {
                String nature = natures.get(i);
                if (this.getModelNaturesIds().contains(nature)) {
                    if (i > 0) {
                        builder.append(SEPARATOR);
                    }
                    builder.append(nature);
                }
                ++i;
            }
        }
        return builder.toString();
    }

    protected void safeExecute(final Command command, TransactionalEditingDomain domain) {
        if (domain == null) {
            command.execute();
        } else {
            RecordingCommand recordingCommand = new RecordingCommand(domain){

                protected void doExecute() {
                    command.execute();
                }
            };
            domain.getCommandStack().execute((Command)recordingCommand);
        }
    }

    @Override
    public Collection<ModelNature> getModelNatures() {
        if (this.natures == null) {
            this.natures = new HashMap<String, ModelNature>();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = reg.getExtensionPoint(MODEL_NATURE_EXTENSION_POINT_ID);
            IExtension[] iExtensionArray = extensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement e = iConfigurationElementArray[n4];
                    String id = e.getAttribute("id");
                    String description = e.getAttribute("description");
                    String name = e.getAttribute("name");
                    this.natures.put(id, new ModelNature(id, description, name));
                    ++n4;
                }
                ++n2;
            }
        }
        return this.natures.values();
    }

    @Override
    public Collection<String> getModelNaturesIds() {
        return Collections2.transform(this.getModelNatures(), (Function)new Function<ModelNature, String>(){

            public String apply(ModelNature arg0) {
                return arg0.getId();
            }
        });
    }
}

