/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.utils;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.storage.IStoragePathProvider;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.uri.IReachableListenerManager;
import org.polarsys.reqcycle.uri.model.Reachable;

public class ManageTraceabilityUtils {
    public static void deleteTraceabilityLink(Link link, IStorageProvider storageProvider, IStoragePathProvider storagePathProvider, IReachableListenerManager listenerManager) {
        Reachable source = (Reachable)Iterables.get((Iterable)link.getSources(), (int)0);
        Reachable target = (Reachable)Iterables.get((Iterable)link.getTargets(), (int)0);
        ITraceabilityStorage storage = null;
        HashSet notification = Sets.newHashSet();
        try {
            storage = storageProvider.getProjectStorageFromLinkId(link.getId());
        }
        catch (NoProjectStorageException noProjectStorageException) {
            String path = storagePathProvider.getStoragePath();
            storage = storageProvider.getStorage(path);
            System.out.println("using default storage path in that case : " + path);
        }
        try {
            try {
                Reachable r = link.getId();
                if (storage != null) {
                    storage.startTransaction();
                    storage.removeTraceabilityLink(r);
                    notification.add(link.getId());
                    notification.add(source);
                    notification.add(target);
                    notification.add(link.getId().trimFragment());
                    storage.commit();
                    listenerManager.notifyChanged(notification.toArray(new Reachable[0]));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (storage != null) {
                    storage.save();
                    storage.dispose();
                }
            }
        }
        finally {
            if (storage != null) {
                storage.save();
                storage.dispose();
            }
        }
    }

    public static void updateLink(Link link, Map<String, String> linkElementsToUpdate, IStorageProvider storageProvider) {
        ITraceabilityStorage storage = null;
        try {
            try {
                storage = storageProvider.getProjectStorageFromLinkId(link.getId());
                if (storage != null) {
                    storage.startTransaction();
                    for (Map.Entry<String, String> changedAttribute : linkElementsToUpdate.entrySet()) {
                        storage.addUpdateProperty(link.getId(), changedAttribute.getKey(), changedAttribute.getValue());
                    }
                    storage.commit();
                }
            }
            catch (NoProjectStorageException noProjectStorageException) {
                System.out.println("could not store link update - no project storage - for link " + link.getId());
                if (storage != null) {
                    storage.save();
                    storage.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (storage != null) {
                    storage.save();
                    storage.dispose();
                }
            }
        }
        finally {
            if (storage != null) {
                storage.save();
                storage.dispose();
            }
        }
    }
}

