/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.vars;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.traceability.storage.Activator;
import org.polarsys.reqcycle.traceability.storage.Variable;
import org.polarsys.reqcycle.utils.configuration.IConfigurationManager;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class VarManager {
    private static final String DEFAULT_PATH = ".traceability";
    IConfigurationManager confManager = (IConfigurationManager)ZigguratInject.make(IConfigurationManager.class);
    private static String EXT_ID = "pathVariable";
    public static String PATTERN_PREF_ID = String.valueOf(Activator.PLUGIN_ID) + ".pref";
    public static String PATTERN_PREF_PATH_ID = "pattern";
    static Map<String, Variable> ALL_VARS = VarManager.getAllVars();

    public String transformPattern(String pattern) {
        if (pattern == null) {
            return DEFAULT_PATH;
        }
        for (Variable v : ALL_VARS.values()) {
            String patternFromVar = this.getPattern(v);
            pattern = pattern.replace(patternFromVar, v.getValue());
        }
        return pattern;
    }

    private String getPattern(Variable arg0) {
        return "{" + arg0.getLabel() + "}";
    }

    public synchronized String getPreferencePattern() {
        try {
            String pattern;
            Map patternMap = this.confManager.getSimpleConfiguration(null, null, PATTERN_PREF_ID, true);
            boolean toSave = false;
            if (patternMap == null) {
                patternMap = Maps.newHashMap();
                patternMap.put(PATTERN_PREF_PATH_ID, DEFAULT_PATH);
                toSave = true;
            }
            if ((pattern = (String)patternMap.get(PATTERN_PREF_PATH_ID)) == null) {
                patternMap.put(PATTERN_PREF_PATH_ID, DEFAULT_PATH);
                toSave = true;
            }
            if (toSave) {
                try {
                    this.confManager.saveSimpleConfiguration(patternMap, null, null, PATTERN_PREF_ID);
                }
                catch (IOException iOException) {}
            }
            return pattern;
        }
        catch (Exception e) {
            e.printStackTrace();
            return DEFAULT_PATH;
        }
    }

    public void setPreferencePattern(String pattern) {
        Map patternMap = this.confManager.getSimpleConfiguration(null, null, PATTERN_PREF_ID, true);
        if (patternMap == null) {
            patternMap = Maps.newHashMap();
        }
        patternMap.put(PATTERN_PREF_PATH_ID, pattern);
        try {
            this.confManager.saveSimpleConfiguration(patternMap, null, null, PATTERN_PREF_ID);
        }
        catch (IOException iOException) {}
    }

    public List<String> getAllPatterns() {
        return Lists.newArrayList((Iterable)Iterables.transform(ALL_VARS.values(), (Function)new Function<Variable, String>(){

            public String apply(Variable arg0) {
                return VarManager.this.getPattern(arg0);
            }
        }));
    }

    private static Map<String, Variable> getAllVars() {
        List<IConfigurationElement> elements = Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor(Activator.PLUGIN_ID, EXT_ID));
        Iterable vars = Iterables.filter((Iterable)Iterables.transform(elements, (Function)new Function<IConfigurationElement, Variable>(){

            public Variable apply(IConfigurationElement arg0) {
                try {
                    return (Variable)arg0.createExecutableExtension("instance");
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
        }), (Predicate)Predicates.notNull());
        return Maps.uniqueIndex((Iterable)vars, (Function)new Function<Variable, String>(){

            public String apply(Variable arg0) {
                return arg0.getLabel();
            }
        });
    }
}

