/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.export.rmf.wizard;

import com.google.common.collect.Lists;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.polarsys.reqcycle.export.rmf.ProviderUtils;
import org.polarsys.reqcycle.export.rmf.page.WizardController;
import org.polarsys.reqcycle.export.rmf.transform.RequirementSourceReqProvider;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.ui.providers.RequirementSourceLabelProvider;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class RequirementSourceSelectionPage
extends WizardPage {
    private static final String[] EXTENSIONS = new String[]{"reqif"};
    private static final String SELECT_OUTPUT_REQIF_FILE = "Select output Reqif file";
    @Inject
    IDataManager requirementSourceManager = (IDataManager)ZigguratInject.make(IDataManager.class);
    protected WizardController controller;
    private List<RequirementSource> selectedSources = Lists.newArrayList();
    private Table table;
    private Table table_1;
    private CheckboxTableViewer reqSourceTableViewer;
    private Text text;

    public RequirementSourceSelectionPage(WizardController controller) {
        super("wizardPage");
        this.controller = controller;
        this.setTitle("ReqIF");
        this.setDescription("Selection of data sources and output file");
    }

    public boolean isPageComplete() {
        return this.reqSourceTableViewer.getCheckedElements().length != 0 && !this.text.getText().isEmpty();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        this.setControl((Control)container);
        container.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        Group grpDataSource = new Group(composite, 0);
        grpDataSource.setLayout((Layout)new GridLayout(1, false));
        grpDataSource.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpDataSource.setText("Data Sources");
        this.reqSourceTableViewer = CheckboxTableViewer.newCheckList((Composite)grpDataSource, (int)67584);
        this.reqSourceTableViewer.setLabelProvider((IBaseLabelProvider)new RequirementSourceLabelProvider());
        this.reqSourceTableViewer.setContentProvider(ProviderUtils.getArrayContentProvider());
        this.reqSourceTableViewer.setInput((Object)this.requirementSourceManager.getRequirementSources());
        this.table = this.reqSourceTableViewer.getTable();
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.reqSourceTableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    RequirementSourceSelectionPage.this.controller.addReqProvider(new RequirementSourceReqProvider((RequirementSource)event.getElement()));
                } else {
                    RequirementSourceSelectionPage.this.controller.removeReqProvider(new RequirementSourceReqProvider((RequirementSource)event.getElement()));
                }
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateButtons();
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateMessage();
            }
        });
        for (RequirementSource s : this.selectedSources) {
            this.reqSourceTableViewer.setChecked((Object)s, true);
        }
        Group grpOutput = new Group(composite, 0);
        grpOutput.setLayout((Layout)new GridLayout(2, false));
        grpOutput.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        grpOutput.setText("Output");
        this.text = new Text((Composite)grpOutput, 2048);
        this.text.setEditable(false);
        this.text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.controller.getOutputUri() != null) {
            this.text.setText(this.controller.getOutputUri().path());
            this.checkExistingFile();
        }
        Button btnNewButton = new Button((Composite)grpOutput, 0);
        btnNewButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ResourceDialog dialog = new ResourceDialog(RequirementSourceSelectionPage.this.getShell(), "blabla", 8196);
                int res = dialog.open();
                if (res == 0) {
                    URI uri = (URI)dialog.getURIs().get(0);
                    if (uri != null) {
                        if (!"reqif".equals(uri.fileExtension())) {
                            uri = uri.trimFileExtension().appendFileExtension("reqif");
                        }
                        RequirementSourceSelectionPage.this.text.setText(uri.toString());
                    }
                    RequirementSourceSelectionPage.this.controller.setOutputUri(uri);
                }
                RequirementSourceSelectionPage.this.checkExistingFile();
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateButtons();
                RequirementSourceSelectionPage.this.getWizard().getContainer().updateMessage();
            }
        });
        btnNewButton.setText("...");
        this.doCreateGroup(composite);
    }

    protected void doCreateGroup(Composite composite) {
    }

    protected void checkExistingFile() {
    }

    public void select(RequirementSource source) {
        this.selectedSources.add(source);
    }
}

