/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.Callable;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource2;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.polarsys.reqcycle.traceability.model.ChangeItem;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.LinkState;
import org.polarsys.reqcycle.traceability.storage.IStorageProvider;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.storage.NoProjectStorageException;
import org.polarsys.reqcycle.traceability.storage.utils.ManageTraceabilityUtils;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.types.RelationBasedType;
import org.polarsys.reqcycle.traceability.ui.views.LinkPropertyDescriptor;
import org.polarsys.reqcycle.traceability.ui.views.LinkStatePropertyDescriptor;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class LinkPropertySource
implements IPropertySource2 {
    private ITraceabilityAttributesManager attributesManager = (ITraceabilityAttributesManager)ZigguratInject.make(ITraceabilityAttributesManager.class);
    private Callable<?> callback;
    Map<String, ITraceabilityAttributesManager.EditableAttribute> attributes = null;
    private Link link;

    public LinkPropertySource(Link link, Callable<?> callback) {
        this.attributes = Maps.uniqueIndex((Iterable)this.attributesManager.getAttributes(link.getId()), (Function)new Function<ITraceabilityAttributesManager.EditableAttribute, String>(){

            public String apply(ITraceabilityAttributesManager.EditableAttribute arg0) {
                return arg0.getName();
            }
        });
        this.callback = callback;
        this.link = link;
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList editableAttributes = Lists.newArrayList(this.attributes.values());
        int nbAttributes = editableAttributes.size();
        int nbDescriptors = nbAttributes + 3;
        IPropertyDescriptor[] descriptors = new IPropertyDescriptor[nbDescriptors];
        int i = 0;
        while (i < editableAttributes.size()) {
            descriptors[i] = new LinkPropertyDescriptor((ITraceabilityAttributesManager.EditableAttribute)editableAttributes.get(i));
            ++i;
        }
        PropertyDescriptor pD = new PropertyDescriptor((Object)"org.polarsys.reqcycle.traceability.lifecycle", "state");
        if (this.link.getKind() instanceof RelationBasedType) {
            pD = new LinkStatePropertyDescriptor("org.polarsys.reqcycle.traceability.lifecycle", "state");
        }
        descriptors[nbAttributes] = pD;
        descriptors[nbAttributes + 1] = new PropertyDescriptor((Object)"org.polarsys.reqcycle.traceability.lastModificationDate", "last Modification Date");
        descriptors[nbAttributes + 2] = new PropertyDescriptor((Object)"org.polarsys.reqcycle.traceability.creationDate", "creation Date");
        return descriptors;
    }

    public Object getPropertyValue(Object id) {
        ITraceabilityAttributesManager.EditableAttribute att = this.attributes.get(id);
        if (att != null) {
            return att.getValue();
        }
        try {
            Reachable traceabilityLink = this.link.getId();
            IStorageProvider provider = this.attributesManager.getStorageManager();
            ITraceabilityStorage storage = provider.getProjectStorageFromLinkId(traceabilityLink);
            if ("org.polarsys.reqcycle.traceability.lifecycle".equals(id)) {
                String value = storage.getProperty(traceabilityLink, "org.polarsys.reqcycle.traceability.lifecycle");
                if (value != null) {
                    this.link.setState(Link.getLinkStateFromString((String)value.toString()));
                }
                return this.link.getState();
            }
            if (this.link.getKind() instanceof RelationBasedType) {
                if ("org.polarsys.reqcycle.traceability.lastModificationDate".equals(id)) {
                    String value = storage.getProperty(traceabilityLink, "org.polarsys.reqcycle.traceability.lastModificationDate");
                    if (value != null) {
                        this.link.setLastModificationDate(Long.parseLong(value));
                    }
                    return new Date(this.link.getLastModificationDate());
                }
                if ("org.polarsys.reqcycle.traceability.creationDate".equals(id)) {
                    String value = storage.getProperty(traceabilityLink, "org.polarsys.reqcycle.traceability.creationDate");
                    if (value != null) {
                        return new Date(Long.parseLong(value));
                    }
                    return new Date(this.link.getCreationDate());
                }
                if ("org.polarsys.reqcycle.traceability.changeHistory".equals(id)) {
                    String value = storage.getProperty(traceabilityLink, "org.polarsys.reqcycle.traceability.changeHistory");
                    if (value != null) {
                        SortedMap history = Link.getHistoryFromString((String)value);
                        this.link.setChangeHistory(history);
                    }
                    return Link.formatHistoryAsString((boolean)true, (SortedMap)this.link.getChangeHistory());
                }
            }
        }
        catch (NoProjectStorageException noProjectStorageException) {
            System.out.println("could not find project storage for traceability link : " + this.link.getId());
        }
        return "";
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
        LinkState newState;
        HashMap<String, String> linkElementsToUpdate = new HashMap<String, String>();
        ITraceabilityAttributesManager.EditableAttribute att = this.attributes.get(id);
        if (att != null) {
            String oldValue = att.getValue().toString();
            att.setValue(value);
            long date = System.currentTimeMillis();
            this.link.setLastModificationDate(date);
            linkElementsToUpdate.put("org.polarsys.reqcycle.traceability.lastModificationDate", "" + date);
            ChangeItem ci = new ChangeItem(att.getName(), oldValue, value.toString());
            this.link.addChangeItem(Long.valueOf(date), ci);
            String changeHistoryAsString = Link.formatHistoryAsStringForStorage((SortedMap)this.link.getChangeHistory());
            linkElementsToUpdate.put("org.polarsys.reqcycle.traceability.changeHistory", changeHistoryAsString);
        } else if ("org.polarsys.reqcycle.traceability.lifecycle".equals(id) && this.link.getKind() instanceof RelationBasedType && value != null && (newState = Link.getLinkStateFromString((String)value.toString())) != this.link.getState()) {
            String oldValue = this.link.getState().name();
            this.link.setState(newState);
            long date = System.currentTimeMillis();
            this.link.setLastModificationDate(date);
            linkElementsToUpdate.put("org.polarsys.reqcycle.traceability.lifecycle", value.toString());
            linkElementsToUpdate.put("org.polarsys.reqcycle.traceability.lastModificationDate", "" + date);
            ChangeItem ci = new ChangeItem("org.polarsys.reqcycle.traceability.lifecycle", oldValue, value.toString());
            this.link.addChangeItem(Long.valueOf(date), ci);
            String changeHistoryAsString = Link.formatHistoryAsStringForStorage((SortedMap)this.link.getChangeHistory());
            linkElementsToUpdate.put("org.polarsys.reqcycle.traceability.changeHistory", changeHistoryAsString);
        }
        IStorageProvider storageProvider = this.attributesManager.getStorageManager();
        ManageTraceabilityUtils.updateLink((Link)this.link, linkElementsToUpdate, (IStorageProvider)storageProvider);
        if (this.callback != null) {
            try {
                this.callback.call();
            }
            catch (Exception exception) {
                System.out.println("issue with calling callback from link update => callback : " + this.callback);
            }
        }
    }

    public boolean isPropertyResettable(Object id) {
        return false;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }
}

