/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.data.ui.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.polarsys.reqcycle.repository.data.IDataManager;
import org.polarsys.reqcycle.repository.data.IDataModelManager;
import org.polarsys.reqcycle.repository.data.RequirementSourceConf.RequirementSource;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementSourceDataPackage;
import org.polarsys.reqcycle.repository.data.RequirementSourceData.RequirementsContainer;
import org.polarsys.reqcycle.repository.data.types.IDataModel;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class UpdateMetaModelHandler
extends AbstractHandler {
    @Inject
    private IDataModelManager dataModelManager = (IDataModelManager)ZigguratInject.make(IDataModelManager.class);
    @Inject
    private IDataManager dataManager = (IDataManager)ZigguratInject.make(IDataManager.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection sel = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (sel instanceof IStructuredSelection) {
            for (Object obj : (IStructuredSelection)sel) {
                String currentDataModelURI;
                IDataModel outdatedDataModel;
                IDataModel updatedDataModel;
                if (!(obj instanceof RequirementSource) || (updatedDataModel = this.dataModelManager.getCurrentDataModel((outdatedDataModel = this.dataModelManager.getDataModelByURI(currentDataModelURI = ((RequirementSource)obj).getDataModelURI())).getName())).getVersion() <= outdatedDataModel.getVersion()) continue;
                this.migrate((RequirementSource)obj, outdatedDataModel, updatedDataModel);
            }
        }
        IWorkbenchPage[] iWorkbenchPageArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPages();
        int n = iWorkbenchPageArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage p = iWorkbenchPageArray[n2];
            IViewReference[] iViewReferenceArray = p.getViewReferences();
            int n3 = iViewReferenceArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Viewer viewer;
                IViewPart v;
                IViewReference vr = iViewReferenceArray[n4];
                if (vr.getId().equals("org.polarsys.reqcycle.repository.ui.views.sources") && (v = vr.getView(false)) != null && (viewer = (Viewer)v.getAdapter(Viewer.class)) != null) {
                    viewer.refresh();
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    private void migrate(RequirementSource reqSource, IDataModel outdatedDataModel, IDataModel updatedDataModel) {
        EPackage outdatedEPackage = (EPackage)((IAdaptable)outdatedDataModel).getAdapter(EPackage.class);
        EPackage updatedEPackage = (EPackage)((IAdaptable)updatedDataModel).getAdapter(EPackage.class);
        final HashMap classesMapping = Maps.newHashMap();
        final HashMap featuresMapping = Maps.newHashMap();
        for (EClassifier updatedEClassifier : updatedEPackage.getEClassifiers()) {
            EClassifier outdatedEClassifier = outdatedEPackage.getEClassifier(updatedEClassifier.getName());
            if (!(outdatedEClassifier instanceof EClass) || !(updatedEClassifier instanceof EClass)) continue;
            classesMapping.put((EClass)outdatedEClassifier, (EClass)updatedEClassifier);
            for (EStructuralFeature updatedFeature : ((EClass)updatedEClassifier).getEStructuralFeatures()) {
                EStructuralFeature outdatedFeature = ((EClass)outdatedEClassifier).getEStructuralFeature(updatedFeature.getName());
                if (outdatedFeature == null) continue;
                featuresMapping.put(outdatedFeature, updatedFeature);
            }
        }
        EcoreUtil.Copier c = new EcoreUtil.Copier(){

            protected EClass getTarget(EClass eClass) {
                if (RequirementSourceDataPackage.eINSTANCE.equals(eClass.getEPackage())) {
                    return eClass;
                }
                return (EClass)classesMapping.get(eClass);
            }

            protected EStructuralFeature getTarget(EStructuralFeature eStructuralFeature) {
                if (RequirementSourceDataPackage.eINSTANCE.equals(eStructuralFeature.getEContainingClass().getEPackage())) {
                    return eStructuralFeature;
                }
                return (EStructuralFeature)featuresMapping.get(eStructuralFeature);
            }
        };
        RequirementsContainer originalContainer = reqSource.getContents();
        Resource resource = originalContainer.eResource();
        HashMap idsMap = Maps.newHashMap();
        TreeIterator it = resource.getAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            idsMap.put(obj, resource.getURIFragment(obj));
        }
        EObject newContainer = c.copy((EObject)originalContainer);
        c.copyReferences();
        reqSource.setContents((RequirementsContainer)newContainer);
        reqSource.setDataModelURI(updatedDataModel.getDataModelURI());
        resource.getContents().remove((Object)originalContainer);
        resource.getContents().add((Object)newContainer);
        BiMap reverse = HashBiMap.create((Map)c).inverse();
        it = resource.getAllContents();
        while (it.hasNext()) {
            String id;
            EObject next = (EObject)it.next();
            EObject originalObj = (EObject)reverse.get((Object)next);
            if (originalObj == null || (id = (String)idsMap.get(originalObj)) == null) continue;
            ((XMLResource)resource).setID(next, id);
        }
        try {
            this.dataManager.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

