/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.model;

import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.traceability.model.ChangeItem;
import org.polarsys.reqcycle.traceability.model.LinkState;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IReachableHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;

public class Link {
    public static final String LINK_LIFECYCLE_ID = "org.polarsys.reqcycle.traceability.lifecycle";
    public static final String LINK_LIFECYCLE_LABEL = "state";
    public static final String LINK_CREATION_DATE_ID = "org.polarsys.reqcycle.traceability.creationDate";
    public static final String LINK_LAST_MODIFICATION_DATE_ID = "org.polarsys.reqcycle.traceability.lastModificationDate";
    public static final String LINK_CHANGE_HISTORY_ID = "org.polarsys.reqcycle.traceability.changeHistory";
    private Set<Reachable> sources = new HashSet<Reachable>();
    private Set<Reachable> targets = new HashSet<Reachable>();
    private TType kind;
    private Reachable id;
    private long creationDate = 0L;
    private long lastModificationDate = 0L;
    private SortedMap<Long, ChangeItem> changeHistory = new TreeMap<Long, ChangeItem>();
    private LinkState state = LinkState.VALIDATED;
    private Set<String> sourceTechnicalVersions;
    private Set<String> targetTechnicalVersions;
    @Inject
    private IReachableManager reachableManager;

    public void setLastModificationDate(long lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public Link(Reachable id, long creationDate, long lastModificationDate, LinkState state, Map<Long, ChangeItem> changeHistory, TType kind, Iterable<Reachable> sources, Iterable<Reachable> targets) {
        this(id, kind, sources, targets);
        this.creationDate = creationDate;
        this.lastModificationDate = lastModificationDate;
        this.state = state;
        this.changeHistory.putAll(changeHistory);
    }

    public Link(Reachable id, TType kind, Iterable<Reachable> sources, Iterable<Reachable> targets) {
        this.id = id;
        this.kind = kind;
        this.sources = Sets.newHashSet(sources);
        this.targets = Sets.newHashSet(targets);
    }

    public Link(Reachable id, TType kind, Reachable source, Reachable target) {
        this(id, kind, Collections.singleton(source), Collections.singleton(target));
    }

    public SortedMap<Long, ChangeItem> getChangeHistory() {
        return this.changeHistory;
    }

    public void setChangeHistory(SortedMap<Long, ChangeItem> changeHistory) {
        this.changeHistory.clear();
        this.changeHistory.putAll(changeHistory);
    }

    public void addChangeItem(Long date, ChangeItem change) {
        this.changeHistory.put(date, change);
    }

    public Reachable getId() {
        return this.id;
    }

    public String getLabel() {
        String label = this.kind.getLabel();
        if (this.kind.getSuperType() != null) {
            label = String.valueOf(label) + " [" + this.kind.getSuperType().getLabel() + "]";
        }
        return label;
    }

    public TType getKind() {
        return this.kind;
    }

    public Set<Reachable> getSources() {
        return Collections.unmodifiableSet(this.sources);
    }

    public Set<Reachable> getTargets() {
        return Collections.unmodifiableSet(this.targets);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Link) {
            Link link = (Link)obj;
            return Objects.equal(this.sources, link.sources) && Objects.equal(this.targets, link.targets) && Objects.equal((Object)this.kind, (Object)link.kind);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.sources, this.targets, this.kind});
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public LinkState getState() {
        return this.state;
    }

    public void setState(LinkState state) {
        this.state = state;
    }

    public boolean hasUnavailableSource() {
        for (Reachable r : this.sources) {
            if (this.isAvailable(r)) continue;
            return true;
        }
        return false;
    }

    public boolean hasUnavailableTarget() {
        for (Reachable r : this.targets) {
            if (this.isAvailable(r)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAvailable(Reachable reachable) {
        ReachableObject fromReachable;
        block9: {
            block8: {
                block7: {
                    if (reachable == null) {
                        return false;
                    }
                    String protocol = reachable.getScheme();
                    if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) break block7;
                    return true;
                }
                IReachableHandler handler = this.reachableManager.getHandlerFromReachable(reachable);
                fromReachable = handler.getFromReachable(reachable);
                IMarker marker = this.getMarker(fromReachable);
                if (marker == null) break block8;
                return true;
            }
            IFile file = this.getFile(fromReachable);
            if (file == null) break block9;
            return true;
        }
        try {
            File f = this.getFileExternal(fromReachable);
            if (f != null) {
                return true;
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected IFile getFile(ReachableObject reachable) {
        IFile res = (IFile)reachable.getAdapter(IFile.class);
        if (res == null) {
            res = (IFile)Platform.getAdapterManager().getAdapter((Object)reachable, IFile.class);
        }
        return res;
    }

    protected File getFileExternal(ReachableObject reachable) {
        File res = (File)reachable.getAdapter(File.class);
        if (res == null) {
            res = (File)Platform.getAdapterManager().getAdapter((Object)reachable, File.class);
        }
        return res;
    }

    protected IMarker getMarker(ReachableObject reachable) {
        IMarker res = (IMarker)reachable.getAdapter(IMarker.class);
        if (res == null) {
            res = (IMarker)Platform.getAdapterManager().getAdapter((Object)reachable, IMarker.class);
        }
        return res;
    }

    public static SortedMap<Long, ChangeItem> getHistoryFromString(String history) {
        String[] lines;
        TreeMap<Long, ChangeItem> historyMap = new TreeMap<Long, ChangeItem>();
        String[] stringArray = lines = history.split("\\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] lineParts = line.split("::");
            if (lineParts.length == 4) {
                String date = lineParts[0];
                Long timeStamp = null;
                try {
                    timeStamp = Long.decode(date);
                    ChangeItem change = new ChangeItem(lineParts[1], lineParts[2], lineParts[3]);
                    historyMap.put(timeStamp, change);
                }
                catch (NumberFormatException nfe) {
                    nfe.printStackTrace();
                }
            }
            ++n2;
        }
        return historyMap;
    }

    public static String formatHistoryAsStringForStorage(SortedMap<Long, ChangeItem> historyMap) {
        return Link.formatHistoryAsString(false, historyMap);
    }

    public static String formatHistoryAsString(boolean dateFormattedForDisplay, SortedMap<Long, ChangeItem> historyMap) {
        StringBuffer sb = new StringBuffer("");
        for (Long key : historyMap.keySet()) {
            ChangeItem ci = (ChangeItem)historyMap.get(key);
            if (dateFormattedForDisplay) {
                sb.append(new Date(key).toString());
            } else {
                sb.append(key.toString());
            }
            sb.append("::" + ci.getAttributeName());
            sb.append("::" + ci.getOldValue());
            sb.append("::" + ci.getNewValue());
            sb.append("\n");
        }
        String changeHistoryAsString = new String(sb);
        return changeHistoryAsString;
    }

    public static LinkState getLinkStateFromString(String state) {
        if ("DEFINED".equals(state)) {
            return LinkState.DEFINED;
        }
        if ("VALIDATED".equals(state)) {
            return LinkState.VALIDATED;
        }
        if ("TO_CHECK".equals(state)) {
            return LinkState.TO_CHECK;
        }
        System.out.println("bug on getState for state " + state);
        return LinkState.DEFINED;
    }
}

