/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import org.polarsys.reqcycle.traceability.storage.ITraceabilityStorage;
import org.polarsys.reqcycle.traceability.types.ITraceabilityAttributesManager;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Attribute;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.AttributeType;
import org.polarsys.reqcycle.uri.model.Reachable;

public class FromStorageEditableAttribute
implements ITraceabilityAttributesManager.EditableAttribute {
    private final ILazyStorageProvider lazyStorageProvider;
    private Attribute attribute;
    private Reachable reachable;
    private Object value = null;

    public FromStorageEditableAttribute(Attribute attribute, Reachable reachable, ILazyStorageProvider lazyStorageProvider) {
        this.attribute = attribute;
        this.reachable = reachable;
        this.lazyStorageProvider = lazyStorageProvider;
    }

    @Override
    public String getName() {
        return this.attribute.getName();
    }

    @Override
    public Object getValue() {
        if (this.value == null) {
            ITraceabilityStorage storage = this.lazyStorageProvider.getStorage();
            String propValue = storage.getProperty(this.reachable, this.attribute.getName());
            this.value = this.getObjectValue(propValue, this.attribute.getType());
        }
        return this.value;
    }

    @Override
    public void setValue(Object value) {
        ITraceabilityStorage storage = this.lazyStorageProvider.getStorage();
        storage.addUpdateProperty(this.reachable, this.attribute.getName(), this.getStringValue(value, this.attribute.getType()));
        storage.commit();
        storage.save();
        this.value = value;
    }

    public String getStringValue(Object val, AttributeType type) {
        switch (type) {
            case INT: {
                return String.valueOf((Integer)val);
            }
            case BOOLEAN: {
                return String.valueOf((Boolean)val);
            }
            case STRING: {
                if (val == null) {
                    return "";
                }
                return val.toString();
            }
        }
        return val.toString();
    }

    public Object getObjectValue(String val, AttributeType type) {
        switch (type) {
            case INT: {
                if (val == null || "null".equals(val)) {
                    return 0;
                }
                return Integer.valueOf(val);
            }
            case BOOLEAN: {
                if (val == null || "null".equals(val)) {
                    return false;
                }
                return Boolean.valueOf(val);
            }
            case STRING: {
                if (val == null || "null".equals(val)) {
                    return "";
                }
                return val;
            }
        }
        return val;
    }

    @Override
    public Object[] getPossibleValues() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.attribute.getPossibleValues(), (Function)new Function<String, Object>(){

            public Object apply(String arg0) {
                return FromStorageEditableAttribute.this.getObjectValue(arg0, FromStorageEditableAttribute.this.attribute.getType());
            }
        })).toArray();
    }

    @Override
    public AttributeType getType() {
        return this.attribute.getType();
    }

    public static interface ILazyStorageProvider {
        public ITraceabilityStorage getStorage();
    }
}

