/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.predicates.ui.dialogs;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.polarsys.reqcycle.predicates.core.api.IEAttrPredicate;

public class IEAttrPredicatesNodeEditorDialog
extends Dialog {
    private TreeViewer treeViewer;
    private final Collection<EClass> eClassesOfModelToEdit;
    private final boolean useExtendedFeature;
    private final IEAttrPredicate eAttrPredicate;
    private EAttribute selectedEAttribute;

    public IEAttrPredicatesNodeEditorDialog(Shell parentShell, IEAttrPredicate eAttrPredicate, Collection<EClass> eClassesOfModelToEdit, boolean useExtendedFeature) {
        super(parentShell);
        this.eAttrPredicate = eAttrPredicate;
        this.eClassesOfModelToEdit = eClassesOfModelToEdit;
        this.useExtendedFeature = useExtendedFeature;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        this.initTreeViewer(container);
        return container;
    }

    private void initTreeViewer(Composite container) {
        this.treeViewer = new TreeViewer(container, 2048);
        Tree tree = this.treeViewer.getTree();
        tree.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.treeViewer.setContentProvider((IContentProvider)new EClassContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new EClassLabelProvider());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListenerImpl());
        this.treeViewer.setInput(this.eClassesOfModelToEdit);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public EAttribute getSelectedEAttribute() {
        return this.selectedEAttribute;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.selectedEAttribute == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"An attribute must be selected");
            return;
        }
        super.buttonPressed(buttonId);
    }

    private class EClassContentProvider
    implements ITreeContentProvider {
        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ArrayContentProvider.getInstance().getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            if (!IEAttrPredicatesNodeEditorDialog.this.useExtendedFeature) {
                if (parentElement instanceof EClass) {
                    return ((EClass)parentElement).getEAllAttributes().toArray();
                }
            } else {
                EClassifier classifier;
                if (parentElement instanceof EClass) {
                    return ((EClass)parentElement).getEAllStructuralFeatures().toArray();
                }
                if (parentElement instanceof EReference) {
                    return ((EReference)parentElement).eContents().toArray();
                }
                if (parentElement instanceof EGenericType && (classifier = ((EGenericType)parentElement).getEClassifier()) != null && classifier instanceof EClass) {
                    return ((EClass)classifier).getEAllStructuralFeatures().toArray();
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).eContainer();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EClass) {
                EList original = ((EClass)element).eContents();
                Collection copy = EcoreUtil.copyAll((Collection)original);
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    EObject eObj = (EObject)iter.next();
                    if (!(eObj instanceof EOperation)) continue;
                    iter.remove();
                }
                return copy.size() > 0;
            }
            if (IEAttrPredicatesNodeEditorDialog.this.useExtendedFeature) {
                return element instanceof EReference || element instanceof EGenericType;
            }
            return false;
        }
    }

    private class EClassLabelProvider
    extends LabelProvider {
        private EClassLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ENamedElement) {
                return ((ENamedElement)element).getName();
            }
            if (element instanceof EGenericType) {
                return this.getText(((EGenericType)element).getEClassifier());
            }
            return super.getText(element);
        }
    }

    private class SelectionChangedListenerImpl
    implements ISelectionChangedListener {
        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection;
            Object selectedObject;
            if (event.getSelection() instanceof IStructuredSelection && (selectedObject = (selection = (IStructuredSelection)event.getSelection()).getFirstElement()) instanceof EAttribute) {
                IEAttrPredicatesNodeEditorDialog.this.selectedEAttribute = (EAttribute)selectedObject;
                EClassifier eType = IEAttrPredicatesNodeEditorDialog.this.selectedEAttribute.getEType();
                Class<Enumerator> selectedClass = eType.getInstanceClass();
                if (selectedClass == null && eType instanceof EEnum) {
                    selectedClass = Enumerator.class;
                }
            }
        }
    }
}

