/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.sirius.dnd;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.navigator.CommonDropAdapterAssistant;
import org.polarsys.reqcycle.dnd.DropRequirementDelegate;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class SiriusDropAdapterAssistant
extends CommonDropAdapterAssistant {
    @Inject
    IReachableManager manager;

    public SiriusDropAdapterAssistant() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        try {
            if (this.manager.getHandlerFromObject(target).getFromObject(target).getReachable() != null) {
                return Status.OK_STATUS;
            }
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
        }
        return Status.CANCEL_STATUS;
    }

    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        try {
            if (LocalSelectionTransfer.getTransfer().isSupportedType(aDropAdapter.getCurrentTransfer())) {
                IAdaptable adaptable;
                if (!(aTarget instanceof EObject) && aTarget instanceof IAdaptable && (adaptable = (IAdaptable)aTarget).getAdapter(EObject.class) != null) {
                    aTarget = adaptable.getAdapter(EObject.class);
                }
                ArrayList reachables = Lists.newArrayList();
                DropRequirementDelegate req = new DropRequirementDelegate();
                if (aDropTargetEvent.data instanceof IStructuredSelection) {
                    IStructuredSelection select = (IStructuredSelection)aDropTargetEvent.data;
                    for (Object o : select) {
                        Reachable reachable = this.manager.getHandlerFromObject(o).getFromObject(o).getReachable();
                        if (reachable != null) {
                            reachables.add(reachable);
                            continue;
                        }
                        return Status.CANCEL_STATUS;
                    }
                }
                IFile file = WorkspaceSynchronizer.getFile((Resource)((EObject)aTarget).eResource());
                req.handleDrop((List)reachables, this.manager.getHandlerFromObject(aTarget).getFromObject(aTarget).getReachable(), (IResource)file);
            }
            return Status.OK_STATUS;
        }
        catch (IReachableHandlerException e) {
            e.printStackTrace();
            return Status.CANCEL_STATUS;
        }
    }
}

