/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.document.traceability;

import com.google.common.base.Joiner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import org.eclipse.core.resources.IFile;
import org.polarsys.reqcycle.document.traceability.DocumentElement;
import org.polarsys.reqcycle.document.traceability.DocumentReachableObject;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class DocumentUtils {
    public static final String DocExtension = "docx";
    public static final String PLATFORM = "platform:";
    public static final String SEPARATOR = "::";
    private static IReachableCreator creator = (IReachableCreator)ZigguratInject.make(IReachableCreator.class);

    public static ReachableObject getReachableObject(IFile file) {
        try {
            DocumentReachableObject DocumentReachableObject2 = new DocumentReachableObject(creator.getReachable(new URI(PLATFORM + file.getFullPath().toString()), (Object)file));
            ZigguratInject.inject((Object[])new Object[]{DocumentReachableObject2});
            return DocumentReachableObject2;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static ReachableObject getReachable(DocumentElement de) {
        try {
            URI uri = new URI(DocumentUtils.getQualifiedURI(de));
            System.out.println("*** getReachable - URI " + uri);
            DocumentReachableObject object = new DocumentReachableObject(creator.getReachable(uri, (Object)de));
            ZigguratInject.inject((Object[])new Object[]{object});
            return object;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected static String getQualifiedURI(DocumentElement element) {
        StringBuilder result = new StringBuilder();
        result.append(PLATFORM).append(element.getResource().getFullPath().toString()).append("#");
        LinkedList<String> names = new LinkedList<String>();
        names.add(element.getElementName());
        DocumentElement parent = element.getParent();
        while (parent != null) {
            names.add(0, parent.getElementName());
            parent = parent.getParent();
        }
        result.append(Joiner.on((String)SEPARATOR).join(names));
        return result.toString();
    }
}

