/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui.views;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.wb.swt.ResourceManager;
import org.polarsys.reqcycle.commands.utils.RelationCommandUtils;
import org.polarsys.reqcycle.commands.utils.RelationCreationDescriptor;
import org.polarsys.reqcycle.dnd.DropRequirementDelegate;
import org.polarsys.reqcycle.traceability.ui.TraceabilityUtils;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.model.IObjectHandler;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.utils.inject.ZigguratInject;

public class TraceabilityCreator
extends ViewPart
implements ISelectionListener {
    public static final String ID = "org.polarsys.reqcycle.traceability.ui.views.TraceabilityCreator";
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private Text sourceText;
    private Text targetText;
    @Inject
    private IReachableManager manager;
    private Reachable source;
    private Reachable target;
    private ISelection selection;

    public TraceabilityCreator() {
        ZigguratInject.inject((Object[])new Object[]{this});
    }

    public void dispose() {
        super.dispose();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
    }

    public void createPartControl(Composite parent) {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout(256));
        Form frmCreation = this.formToolkit.createForm(container);
        this.formToolkit.paintBordersFor((Composite)frmCreation);
        frmCreation.setText("Create a traceability link");
        frmCreation.getBody().setLayout((Layout)new FillLayout(256));
        Section sctnNewSection = this.formToolkit.createSection(frmCreation.getBody(), 320);
        this.formToolkit.paintBordersFor((Composite)sctnNewSection);
        sctnNewSection.setText("Source and Target");
        Composite composite = new Composite((Composite)sctnNewSection, 0);
        this.formToolkit.adapt(composite);
        this.formToolkit.paintBordersFor(composite);
        sctnNewSection.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(3, false));
        Label lblSource = new Label(composite, 0);
        lblSource.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)lblSource, true, true);
        lblSource.setText("Source :");
        this.sourceText = new Text(composite, 2048);
        this.sourceText.setEditable(false);
        this.sourceText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.sourceText, true, true);
        Button btnSetSource = new Button(composite, 0);
        btnSetSource.addSelectionListener((SelectionListener)new AddSelectionListener(new SourceSetter()));
        btnSetSource.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.ui", "icons/add_obj.gif"));
        this.formToolkit.adapt((Control)btnSetSource, true, true);
        Label lblTarget = new Label(composite, 0);
        lblTarget.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.formToolkit.adapt((Control)lblTarget, true, true);
        lblTarget.setText("Target :");
        this.targetText = new Text(composite, 2048);
        this.targetText.setEditable(false);
        this.targetText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formToolkit.adapt((Control)this.targetText, true, true);
        Button btnSetTarget = new Button(composite, 0);
        btnSetTarget.addSelectionListener((SelectionListener)new AddSelectionListener(new TargetSetter()));
        btnSetTarget.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.ui", "icons/add_obj.gif"));
        this.formToolkit.adapt((Control)btnSetTarget, true, true);
        new Label(composite, 0);
        new Label(composite, 0);
        Button btnCreateLink = this.formToolkit.createButton(composite, "", 0);
        btnCreateLink.setImage(ResourceManager.getPluginImage("org.polarsys.reqcycle.traceability.ui", "icons/locate.gif"));
        btnCreateLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TraceabilityCreator.this.target != null && TraceabilityCreator.this.source != null) {
                    TraceabilityCreator.this.createTraceability();
                }
            }
        });
        this.createActions();
        this.initializeToolBar();
        this.initializeMenu();
    }

    private void createActions() {
    }

    private void initializeToolBar() {
        this.getViewSite().getActionBars().getToolBarManager();
    }

    private void initializeMenu() {
        this.getViewSite().getActionBars().getMenuManager();
    }

    public void setFocus() {
    }

    private void handleCurrentSelection(ISetter setter) {
        if (this.selection != null && !this.selection.isEmpty() && this.selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)this.selection;
            for (Object o : structured) {
                if (o == null) {
                    setter.set(null);
                    continue;
                }
                setter.set(o);
            }
        }
    }

    public Reachable getReachable(Object o) {
        try {
            IObjectHandler handler = this.manager.getHandlerFromObject(o);
            ReachableObject reachableObject = handler.getFromObject(o);
            if (reachableObject != null) {
                return reachableObject.getReachable();
            }
        }
        catch (IReachableHandlerException iReachableHandlerException) {}
        return null;
    }

    protected void createTraceability() {
        Iterator iteratorDU;
        Set allCommands = RelationCommandUtils.getAllRelationCommands(Collections.singletonList(this.source), Collections.singletonList(this.target));
        Iterable upstreamToDownstreams = Iterables.filter((Iterable)allCommands, (Predicate)new Predicate<RelationCreationDescriptor>(){

            public boolean apply(RelationCreationDescriptor desc) {
                return desc.isUpstreamToDownstream();
            }
        });
        Iterable downstreamToUpstream = Iterables.filter((Iterable)allCommands, (Predicate)new Predicate<RelationCreationDescriptor>(){

            public boolean apply(RelationCreationDescriptor desc) {
                return desc.isDownstreamToUpstream();
            }
        });
        Menu menu = new Menu((Control)Display.getDefault().getActiveShell());
        Iterator iteratorUD = upstreamToDownstreams.iterator();
        if (iteratorUD.hasNext()) {
            DropRequirementDelegate.createMenu((Menu)menu, (String)"Up To Down", iteratorUD, (List)Lists.newArrayList((Object[])new Reachable[]{this.source}), (Reachable)this.target, (int)1);
        }
        if ((iteratorDU = downstreamToUpstream.iterator()).hasNext()) {
            DropRequirementDelegate.createMenu((Menu)menu, (String)"Down To Up", iteratorDU, (List)Lists.newArrayList((Object[])new Reachable[]{this.source}), (Reachable)this.target, (int)-1);
        }
        menu.setVisible(true);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (part != this && !(part instanceof PropertySheet)) {
            this.selection = selection;
        }
    }

    private class AddSelectionListener
    implements SelectionListener {
        private ISetter setter;

        public AddSelectionListener(ISetter s) {
            this.setter = s;
        }

        public void widgetSelected(SelectionEvent e) {
            TraceabilityCreator.this.handleCurrentSelection(this.setter);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private static interface ISetter {
        public void set(Object var1);
    }

    private class SourceSetter
    implements ISetter {
        private SourceSetter() {
        }

        @Override
        public void set(Object o) {
            if (o == null) {
                TraceabilityCreator.this.sourceText.setText("invalid selection");
                TraceabilityCreator.this.source = null;
            } else {
                Reachable r = TraceabilityCreator.this.getReachable(o);
                if (r != null) {
                    TraceabilityCreator.this.source = r;
                    TraceabilityCreator.this.sourceText.setText(TraceabilityUtils.getText(r));
                } else {
                    TraceabilityCreator.this.sourceText.setText("invalid selection");
                    TraceabilityCreator.this.source = null;
                }
            }
        }
    }

    private class TargetSetter
    implements ISetter {
        private TargetSetter() {
        }

        @Override
        public void set(Object o) {
            if (o == null) {
                TraceabilityCreator.this.targetText.setText("invalid selection");
                TraceabilityCreator.this.target = null;
            } else {
                Reachable r = TraceabilityCreator.this.getReachable(o);
                if (r != null) {
                    TraceabilityCreator.this.target = r;
                    TraceabilityCreator.this.targetText.setText(TraceabilityUtils.getText(r));
                } else {
                    TraceabilityCreator.this.targetText.setText("invalid selection");
                    TraceabilityCreator.this.target = null;
                }
            }
        }
    }
}

