/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

final class SLPUtils {
    private SLPUtils() {
    }

    static List dictToAttrList(Dictionary attributes) {
        ArrayList<String> attList = new ArrayList<String>();
        if (attributes != null) {
            Enumeration keys = attributes.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                StringBuffer buffer = new StringBuffer();
                buffer.append("(");
                buffer.append(key);
                buffer.append("=");
                buffer.append(attributes.get(key));
                buffer.append(")");
                attList.add(buffer.toString());
            }
        }
        return attList;
    }

    static Dictionary attrListToDict(List attrList) {
        Hashtable<String, String> dict = new Hashtable<String, String>();
        for (String attrStr : attrList) {
            int pos = (attrStr = attrStr.substring(1, attrStr.length() - 1)).indexOf("=");
            if (pos <= -1) continue;
            String key = attrStr.substring(0, pos).trim();
            String value = attrStr.substring(pos + 1).trim();
            ((Dictionary)dict).put(key, value);
        }
        return dict;
    }

    static void addValue(Map map, Object key, Object value) {
        ArrayList<Object> values = (ArrayList<Object>)map.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
        }
        if (values.contains(value)) {
            return;
        }
        values.add(value);
        map.put(key, values);
    }

    static void removeValue(Map map, Object key, Object value) {
        List values = (List)map.get(key);
        if (values == null) {
            return;
        }
        values.remove(value);
        if (!values.isEmpty()) {
            map.put(key, values);
        } else {
            map.remove(key);
        }
    }

    static void removeValueFromAll(Map map, Object value) {
        Object[] keys = map.keySet().toArray();
        int i = 0;
        while (i < keys.length) {
            List list = (List)map.get(keys[i]);
            list.remove(value);
            if (list.isEmpty()) {
                map.remove(keys[i]);
            }
            ++i;
        }
    }

    static int getTimestamp() {
        long systemTime = System.currentTimeMillis();
        return (int)(systemTime /= 1000L);
    }

    static List findMatches(List keyList, Dictionary attributes) {
        ArrayList<String> results = new ArrayList<String>();
        HashSet<String> caseInsensitiveKeyList = new HashSet<String>();
        ArrayList<String> wildcards = new ArrayList<String>();
        if (!keyList.isEmpty()) {
            for (String key : keyList) {
                if (key.indexOf("*") == -1) {
                    caseInsensitiveKeyList.add(key.toLowerCase());
                    continue;
                }
                wildcards.add(key);
            }
        }
        Enumeration keys = attributes.keys();
        while (keys.hasMoreElements()) {
            String key;
            key = (String)keys.nextElement();
            if (keyList.isEmpty() || caseInsensitiveKeyList.contains(key.toLowerCase())) {
                results.add("(" + key + "=" + attributes.get(key).toString() + ")");
                continue;
            }
            for (String wildcard : wildcards) {
                if (!SLPUtils.equalsWithWildcard(wildcard.toCharArray(), 0, key.toCharArray(), 0)) continue;
                results.add("(" + key + "=" + attributes.get(key).toString() + ")");
            }
        }
        return results;
    }

    private static boolean equalsWithWildcard(char[] val, int valIndex, char[] attr, int attrIndex) {
        if (val.length == valIndex) {
            return attr.length == attrIndex;
        }
        if (val[valIndex] == '*') {
            ++valIndex;
            do {
                if (!SLPUtils.equalsWithWildcard(val, valIndex, attr, attrIndex)) continue;
                return true;
            } while (attr.length - ++attrIndex > -1);
            return false;
        }
        return attr.length == attrIndex || attr[attrIndex] != val[valIndex] ? false : SLPUtils.equalsWithWildcard(val, ++valIndex, attr, ++attrIndex);
    }
}

