/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.example.clients.applications;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.example.clients.IMessageReceiver;
import org.eclipse.ecf.example.clients.XMPPChatRoomClient;
import org.eclipse.ecf.presence.IIMMessageEvent;
import org.eclipse.ecf.presence.IIMMessageListener;
import org.eclipse.ecf.presence.chatroom.IChatRoomContainer;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageEvent;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessageSender;
import org.eclipse.ecf.presence.im.IChatMessage;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;

public class ChatRoomRobotApplication
implements IApplication,
IMessageReceiver,
IIMMessageListener {
    private String senderAccount;
    private Object lock = new Object();
    private boolean done = false;
    private IChatRoomMessageSender sender;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object start(IApplicationContext context) throws Exception {
        String[] originalArgs = (String[])context.getArguments().get("application.args");
        if (originalArgs.length < 4) {
            System.out.println("Parameters:  <senderAccount> <senderPassword> <chatroomname>.  e.g. sender@gmail.com senderpassword mychatroom");
            return new Integer(-1);
        }
        this.senderAccount = originalArgs[0];
        XMPPChatRoomClient client = new XMPPChatRoomClient(this);
        client.connect(this.senderAccount, originalArgs[1]);
        IChatRoomContainer chatRoomContainer = client.createChatRoom(originalArgs[2]);
        chatRoomContainer.connect(client.getChatRoomInfo().getRoomID(), null);
        System.out.println("ECF chat room robot sender=" + this.senderAccount + "  Connected to room: " + client.getChatRoomInfo().getRoomID().getName());
        chatRoomContainer.addMessageListener((IIMMessageListener)this);
        this.sender = chatRoomContainer.getChatRoomMessageSender();
        this.sender.sendMessage("Hi, I'm a robot. To get rid of me, send me a direct message.");
        Object object = this.lock;
        synchronized (object) {
            while (!this.done) {
                this.lock.wait();
            }
        }
        return IApplication.EXIT_OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(IChatMessage chatMessage) {
        try {
            this.sender.sendMessage("gotta run");
        }
        catch (ECFException e) {
            e.printStackTrace();
        }
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notify();
        }
    }

    public void handleMessageEvent(IIMMessageEvent messageEvent) {
        if (messageEvent instanceof IChatRoomMessageEvent) {
            IChatRoomMessage m = ((IChatRoomMessageEvent)messageEvent).getChatRoomMessage();
            this.handleChatRoomMessage(m.getFromID(), m.getMessage());
        }
    }

    private void handleChatRoomMessage(ID fromID, String messageBody) {
        if (fromID.getName().indexOf(this.senderAccount) != -1) {
            return;
        }
        try {
            if (messageBody.indexOf("e") != -1) {
                this.sender.sendMessage("kewl");
            } else if (messageBody.indexOf("s") != -1) {
                this.sender.sendMessage(";-)");
            } else {
                this.sender.sendMessage("'s up?");
            }
        }
        catch (ECFException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notify();
        }
    }
}

