/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.presence.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.IContainerListener;
import org.eclipse.ecf.core.events.IContainerDisconnectedEvent;
import org.eclipse.ecf.core.events.IContainerEvent;
import org.eclipse.ecf.core.util.ECFException;
import org.eclipse.ecf.internal.presence.ui.Activator;
import org.eclipse.ecf.internal.presence.ui.Messages;
import org.eclipse.ecf.presence.IPresenceContainerAdapter;
import org.eclipse.ecf.presence.roster.IRosterSubscriptionSender;
import org.eclipse.ecf.presence.search.IResult;
import org.eclipse.ecf.presence.search.IResultList;
import org.eclipse.ecf.presence.ui.MultiRosterAccount;
import org.eclipse.ecf.presence.ui.UserSearchContentProvider;
import org.eclipse.ecf.presence.ui.UserSearchLabelProvider;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class UserSearchView
extends ViewPart {
    public static final String VIEW_ID = "org.eclipse.ecf.presence.ui.UserSearchView";
    protected static final int DEFAULT_EXPAND_LEVEL = 3;
    protected TreeViewer treeViewer;
    protected List users = new ArrayList();
    private IAction addContactAction;
    private MultiRosterAccount account;
    private PageBook pageBook;
    private Label helpMessageLabel;
    private IContainerListener listener;

    public void createPartControl(Composite parent) {
        this.pageBook = new PageBook(parent, 0);
        this.createHelpMessage((Composite)this.pageBook);
        this.setupTreeViewer((Composite)this.pageBook);
        if (this.users.size() == 0) {
            this.pageBook.showPage((Control)this.helpMessageLabel);
        }
    }

    private void createHelpMessage(Composite parent) {
        if (!parent.isDisposed()) {
            this.helpMessageLabel = new Label(parent, 16576);
        }
    }

    protected void setupTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2564);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.treeViewer.setContentProvider((IContentProvider)new UserSearchContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new UserSearchLabelProvider());
        this.makeActions();
        this.hookContextMenu();
    }

    private void makeActions() {
        this.addContactAction = new Action(Messages.MultiRosterView_AddContact, SharedImages.getImageDescriptor((String)"IMG_ADD_BUDDY")){

            public void run() {
                ITreeSelection selection = (ITreeSelection)UserSearchView.this.treeViewer.getSelection();
                IResult contact = (IResult)selection.getFirstElement();
                if (MessageDialog.openConfirm(null, (String)Messages.AddContactDialog_DialogTitle, (String)NLS.bind((String)Messages.SearchContactDialog_AddContactMessage, (Object)contact.getUser().getName()))) {
                    IPresenceContainerAdapter ipca = UserSearchView.this.account.getPresenceContainerAdapter();
                    IRosterSubscriptionSender sender = ipca.getRosterManager().getRosterSubscriptionSender();
                    try {
                        sender.sendRosterAdd(contact.getUser().getID().getName(), contact.getUser().getName(), null);
                    }
                    catch (ECFException e) {
                        Activator.getDefault().getLog().log(e.getStatus());
                    }
                }
            }
        };
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UserSearchView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void fillContextMenu(IMenuManager manager) {
        IStructuredSelection iss = (IStructuredSelection)this.treeViewer.getSelection();
        Object element = iss.getFirstElement();
        if (element instanceof IResult) {
            manager.add(this.addContactAction);
        }
    }

    public void dispose() {
        this.treeViewer = null;
        this.users.clear();
        if (this.account != null) {
            this.account.container.removeListener(this.listener);
        }
        super.dispose();
    }

    public void setFocus() {
        if (this.treeViewer != null) {
            this.treeViewer.getControl().setFocus();
        }
    }

    public boolean addResult(IResultList list) {
        this.users.clear();
        this.users.add(list);
        this.treeViewer.setInput((Object)this.users);
        this.pageBook.showPage(this.treeViewer.getControl());
        this.treeViewer.expandToLevel(3);
        this.helpMessageLabel.setText("");
        return true;
    }

    public boolean addMultiRosterAccount(MultiRosterAccount multiRosterAccount) {
        Assert.isNotNull((Object)multiRosterAccount);
        this.account = multiRosterAccount;
        this.listener = new IContainerListener(){

            public void handleEvent(IContainerEvent event) {
                if (event instanceof IContainerDisconnectedEvent) {
                    UserSearchView.this.users.clear();
                    UserSearchView.this.showMessage(Messages.MultiRosterView_HELP_MESSAGE);
                }
            }
        };
        this.account.container.addListener(this.listener);
        return true;
    }

    public void showMessage(String message) {
        this.helpMessageLabel.setText(message);
        this.pageBook.showPage((Control)this.helpMessageLabel);
    }
}

