/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.iks.slp.impl;

import ch.ethz.iks.slp.impl.PlatformAbstraction;
import ch.ethz.iks.slp.impl.SLPCore;
import ch.ethz.iks.slp.impl.filter.Filter;
import java.util.Dictionary;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;
import org.osgi.service.log.Logger;

public class OSGiPlatformAbstraction
implements PlatformAbstraction,
ServiceListener {
    private final BundleContext context;
    private LogService log = new NullPatternLogService();

    OSGiPlatformAbstraction(BundleContext context) throws InvalidSyntaxException {
        this.context = context;
        ServiceReference sref = context.getServiceReference(LogService.class.getName());
        if (sref != null) {
            this.log = (LogService)context.getService(sref);
        }
        context.addServiceListener((ServiceListener)this, "(objectClass=" + LogService.class.getName() + ")");
        this.logDebug("jSLP OSGi started.");
    }

    public Filter createFilter(String filterString) {
        try {
            final org.osgi.framework.Filter filter = this.context.createFilter(filterString);
            return new Filter(){

                public boolean match(Dictionary values) {
                    return filter.match(values);
                }

                public String toString() {
                    return filter.toString();
                }
            };
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public void logDebug(String message) {
        if (SLPCore.CONFIG.getDebugEnabled()) {
            this.log.log(4, message);
        }
    }

    public void logDebug(String message, Throwable exception) {
        if (SLPCore.CONFIG.getDebugEnabled()) {
            this.log.log(4, message, exception);
        }
    }

    public void logError(String message) {
        this.log.log(1, message);
    }

    public void logError(String message, Throwable exception) {
        this.log.log(1, message, exception);
    }

    public void logTraceMessage(String message) {
        if (SLPCore.CONFIG.getTraceMessage()) {
            this.log.log(3, message);
        }
    }

    public void logTraceDrop(String message) {
        if (SLPCore.CONFIG.getTraceDrop()) {
            this.log.log(3, message);
        }
    }

    public void logTraceReg(String message) {
        if (SLPCore.CONFIG.getTraceReg()) {
            this.log.log(3, message);
        }
    }

    public void logWarning(String message) {
        this.log.log(2, message);
    }

    public void logWarning(String message, Throwable exception) {
        this.log.log(2, message, exception);
    }

    public void serviceChanged(ServiceEvent event) {
        switch (event.getType()) {
            case 1: {
                this.log = (LogService)this.context.getService(event.getServiceReference());
                return;
            }
            case 4: {
                this.log = new NullPatternLogService();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NullPatternLogService
    implements LogService {
        private NullPatternLogService() {
        }

        public void log(int level, String message) {
            if (level == 1 || level == 2) {
                System.err.println(message);
            } else {
                System.out.println(message);
            }
        }

        public void log(int level, String message, Throwable exception) {
            this.log(level, String.valueOf(message) + " " + exception.toString());
        }

        public void log(ServiceReference sr, int level, String message) {
            this.log(null, level, message);
        }

        public void log(ServiceReference sr, int level, String message, Throwable t) {
            this.log(null, level, message, t);
        }

        public Logger getLogger(String name) {
            throw new UnsupportedOperationException();
        }

        public Logger getLogger(Class<?> clazz) {
            throw new UnsupportedOperationException();
        }

        public <L extends Logger> L getLogger(String name, Class<L> loggerType) {
            throw new UnsupportedOperationException();
        }

        public <L extends Logger> L getLogger(Class<?> clazz, Class<L> loggerType) {
            throw new UnsupportedOperationException();
        }

        public <L extends Logger> L getLogger(Bundle bundle, String name, Class<L> loggerType) {
            throw new UnsupportedOperationException();
        }
    }
}

