/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.generic;

import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.sharedobject.ISharedObjectContainerConfig;
import org.eclipse.ecf.provider.comm.ConnectionCreateException;
import org.eclipse.ecf.provider.comm.ISynchAsynchConnection;
import org.eclipse.ecf.provider.comm.tcp.Client;
import org.eclipse.ecf.provider.generic.ClientSOContainer;
import org.eclipse.ecf.provider.generic.SOContainerConfig;

public class TCPClientSOContainer
extends ClientSOContainer {
    int keepAlive = 0;
    public static final int DEFAULT_TCP_CONNECT_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.ecf.provider.generic.TCPClientSOContainer.defaultConnectTimeout", "30000"));
    public static final String DEFAULT_COMM_NAME = Client.class.getName();

    public TCPClientSOContainer(ISharedObjectContainerConfig config) {
        super(config);
    }

    public TCPClientSOContainer(ISharedObjectContainerConfig config, int ka) {
        super(config);
        this.keepAlive = ka;
    }

    @Override
    protected int getConnectTimeout() {
        return DEFAULT_TCP_CONNECT_TIMEOUT;
    }

    @Override
    protected ISynchAsynchConnection createConnection(ID remoteSpace, Object data) throws ConnectionCreateException {
        this.debug("createClientConnection:" + remoteSpace + ":" + data);
        Client conn = new Client(this.receiver, this.keepAlive);
        return conn;
    }

    public static final void main(String[] args) throws Exception {
        SOContainerConfig config = new SOContainerConfig(IDFactory.getDefault().createGUID());
        TCPClientSOContainer container = new TCPClientSOContainer(config);
        ID serverID = IDFactory.getDefault().createStringID("ecftcp://localhost:3282/server");
        container.connect(serverID, null);
        Thread.sleep(200000L);
    }
}

