/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.example.collab.ui;

import org.eclipse.ecf.internal.example.collab.Messages;
import org.eclipse.ecf.internal.example.collab.ui.ChatComposite;
import org.eclipse.ecf.internal.example.collab.ui.LineChatClientView;
import org.eclipse.ecf.ui.SharedImages;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ChatWindow
extends ApplicationWindow {
    private static final long FLASH_INTERVAL = 600L;
    private final LineChatClientView view;
    private final TableViewer table;
    private final String initText;
    private ChatComposite chat;
    private Image image;
    private Image blank;
    private boolean flashing;
    private final Runnable flipImage = new Runnable(){

        public void run() {
            Shell shell = ChatWindow.this.getShell();
            if (shell != null && !shell.isDisposed()) {
                if (ChatWindow.this.blank == shell.getImage()) {
                    if (ChatWindow.this.image != null && !ChatWindow.this.image.isDisposed()) {
                        shell.setImage(ChatWindow.this.image);
                    }
                } else if (ChatWindow.this.blank != null && !ChatWindow.this.blank.isDisposed()) {
                    shell.setImage(ChatWindow.this.blank);
                }
            }
        }
    };
    private Flash flash;

    public ChatWindow(LineChatClientView view, TableViewer table, String initText) {
        super(null);
        this.view = view;
        this.table = table;
        this.initText = initText;
        this.addStatusLine();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(NLS.bind((String)Messages.ChatWindow_SHELL_TEXT, (Object)this.view.name));
        this.image = SharedImages.getImage((String)"IMG_USER_AVAILABLE");
        newShell.setImage(this.image);
        RGB[] colors = new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)};
        ImageData data = new ImageData(16, 16, 1, new PaletteData(colors));
        data.transparentPixel = 0;
        this.blank = new Image((Device)newShell.getDisplay(), data);
        this.flash = new Flash(newShell.getDisplay());
        new Thread(this.flash).start();
        newShell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ChatWindow.this.flash != null) {
                    ChatWindow.this.flash.dispose();
                }
                if (ChatWindow.this.blank != null) {
                    ChatWindow.this.blank.dispose();
                }
            }
        });
        newShell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                ChatWindow.this.stopFlashing();
                if (!ChatWindow.this.chat.isDisposed()) {
                    ((ChatWindow)ChatWindow.this).chat.textinput.setFocus();
                }
            }
        });
    }

    protected Control createContents(Composite parent) {
        this.chat = new ChatComposite(this.view, parent, this.table, this.initText, this);
        this.chat.setLayoutData(new GridData(1808));
        this.chat.setFont(parent.getFont());
        return this.chat;
    }

    ChatComposite getChat() {
        return this.chat;
    }

    boolean hasFocus() {
        if (this.getShell().isDisposed()) {
            return false;
        }
        return this.hasFocus((Composite)this.getShell());
    }

    private boolean hasFocus(Composite composite) {
        if (composite.isFocusControl()) {
            return true;
        }
        Control[] children = composite.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof Composite && this.hasFocus((Composite)children[i])) {
                return true;
            }
            if (children[i].isFocusControl()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flash() {
        Flash flash = this.flash;
        synchronized (flash) {
            if (!this.flashing) {
                this.flashing = true;
                this.flash.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopFlashing() {
        Flash flash = this.flash;
        synchronized (flash) {
            if (this.flashing) {
                this.flashing = false;
                if (!this.getShell().isDisposed() && this.image != null && !this.image.isDisposed()) {
                    this.getShell().setImage(this.image);
                }
            }
        }
    }

    protected void handleShellCloseEvent() {
        if (!this.getShell().isDisposed()) {
            this.getShell().setVisible(false);
        }
    }

    private class Flash
    implements Runnable {
        private final Display display;
        private boolean disposed;

        public Flash(Display display) {
            this.display = display;
        }

        public synchronized void dispose() {
            if (!this.disposed) {
                this.disposed = true;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                Flash flash = this;
                synchronized (flash) {
                    try {
                        while (!ChatWindow.this.flashing && !this.disposed) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
                if (this.disposed && this.display.isDisposed()) break;
                this.display.syncExec(ChatWindow.this.flipImage);
                flash = this;
                synchronized (flash) {
                    try {
                        this.wait(600L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        }
    }
}

