/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.presence.bot;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.ecf.presence.bot.IChatRoomMessageHandler;
import org.eclipse.ecf.presence.bot.IChatRoomMessageHandlerEntry;
import org.eclipse.ecf.presence.chatroom.IChatRoomMessage;

public class ChatRoomMessageHandlerEntry
implements IChatRoomMessageHandlerEntry {
    private String expression;
    private IChatRoomMessageHandler handler;

    public ChatRoomMessageHandlerEntry(String expression, IChatRoomMessageHandler handler) {
        this.expression = expression;
        this.handler = handler;
    }

    public String getExpression() {
        return this.expression;
    }

    public IChatRoomMessageHandler getHandler() {
        return this.handler;
    }

    public void handleRoomMessage(IChatRoomMessage message) {
        if (this.expression == null || this.canExecute(message.getMessage())) {
            this.handler.handleRoomMessage(message);
        }
    }

    private boolean canExecute(String message) {
        Pattern pattern = Pattern.compile(this.getExpression(), 42);
        Matcher matcher = pattern.matcher(message);
        return matcher.matches();
    }
}

