/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.core;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.discovery.identity.ServiceTypeID;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceID;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryServiceTypeID;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryTargetID;

public class ZooDiscoveryNamespace
extends Namespace {
    private static final long serialVersionUID = 3925693055869405334L;
    public static final String NAME = "ecf.namespace.zoodiscovery";

    public ZooDiscoveryNamespace() {
        super(NAME, "ZooKeeper Discovery Namespace");
    }

    public ID createInstance(Object[] parameters) throws IDCreateException {
        Assert.isTrue((parameters != null && parameters.length > 0 ? 1 : 0) != 0);
        try {
            if (parameters[0] instanceof String && parameters instanceof String[]) {
                return new ZooDiscoveryTargetID(this, (String[])parameters);
            }
            if (parameters.length == 1 && parameters[0] instanceof IServiceTypeID) {
                return new ZooDiscoveryServiceTypeID(this, (IServiceTypeID)parameters[0]);
            }
            if (parameters.length == 2 && parameters[0] instanceof IServiceTypeID && parameters[1] instanceof URI) {
                return new ZooDiscoveryServiceID(this, (IServiceTypeID)parameters[0], (URI)parameters[1]);
            }
            if (parameters.length == 2 && parameters[0] instanceof String && parameters[1] instanceof URI) {
                String type = (String)parameters[0];
                return new ZooDiscoveryServiceID(this, (IServiceTypeID)new ServiceTypeID((Namespace)this, type), (URI)parameters[1]);
            }
        }
        catch (Exception e) {
            throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", (Throwable)e);
        }
        return null;
    }

    public String getScheme() {
        return ((Object)((Object)this)).getClass().toString();
    }

    public Class[][] getSupportedParameterTypes() {
        return new Class[][]{{String.class}, {IServiceTypeID.class}, {IServiceTypeID.class, URI.class}};
    }

    public static long getSerialversionuid() {
        return 3925693055869405334L;
    }
}

