/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.provider.filetransfer.scp;

import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.IRemoteFile;
import org.eclipse.ecf.filetransfer.IRemoteFileSystemListener;
import org.eclipse.ecf.filetransfer.identity.FileCreateException;
import org.eclipse.ecf.filetransfer.identity.FileIDFactory;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.internal.provider.filetransfer.scp.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.scp.IScpFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.scp.ScpUtil;
import org.eclipse.ecf.provider.filetransfer.browse.AbstractFileSystemBrowser;
import org.eclipse.ecf.provider.filetransfer.browse.URLRemoteFile;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;

public class ScpFileSystemBrowser
extends AbstractFileSystemBrowser
implements IScpFileTransfer {
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected ScpUtil scpUtil;
    protected ChannelExec channel;
    protected String username;
    protected static final String SCP_EXEC = System.getProperty("org.eclipse.ecf.filetransfer.scp.filebrowse.exec", "exec");
    protected static final String LS_START_COMMAND = System.getProperty("org.eclipse.ecf.filetransfer.scp.filebrowse.lscommand.start", "IFS=\"$(printf '\n\t')\"; shopt -s dotglob; for file in ");
    protected static final String LS_END_COMMAND = System.getProperty("org.eclipse.ecf.filetransfer.scp.filebrowse.lscommand.end", "/*; do stat --format='%F|%s|%Y|%n' $file; done ");

    public ScpFileSystemBrowser(IFileID directoryOrFileID, IRemoteFileSystemListener listener, URL url, IConnectContext connectContext, Proxy proxy) {
        super(directoryOrFileID, listener, url, connectContext, proxy);
        this.username = this.directoryOrFile.getUserInfo();
    }

    protected void runRequest() throws Exception {
        this.scpUtil = new ScpUtil(this);
        Session s = this.scpUtil.getSession();
        s.connect();
        if (s.isConnected()) {
            String targetFileName = this.scpUtil.trimTargetFile(this.directoryOrFile.getPath());
            String command = String.valueOf(LS_START_COMMAND) + targetFileName + LS_END_COMMAND;
            this.channel = (ChannelExec)s.openChannel(SCP_EXEC);
            this.channel.setCommand(command);
            OutputStream outs = this.channel.getOutputStream();
            this.inputStream = this.channel.getInputStream();
            this.channel.connect();
            this.setOutputStream(outs);
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.inputStream));
            String line = reader.readLine();
            ArrayList<String> strings = new ArrayList<String>();
            while (line != null) {
                strings.add(line);
                line = reader.readLine();
            }
            ArrayList<IRemoteFile> remoteFilesList = new ArrayList<IRemoteFile>();
            int i = 0;
            while (i < strings.size()) {
                try {
                    remoteFilesList.add(this.createRemoteFile((String)strings.get(i)));
                }
                catch (Exception e) {
                    Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.scp", 4, "SCPFileBrowser could not convert string '" + (String)strings.get(i) + "' to FileID", (Throwable)e));
                }
                ++i;
            }
            this.remoteFiles = remoteFilesList.toArray(new IRemoteFile[remoteFilesList.size()]);
        }
    }

    private IRemoteFile createRemoteFile(String string) throws URISyntaxException, FileCreateException, SecurityException {
        URLRemoteFile file = null;
        IFileID id = null;
        String[] parts = string.split("\\|");
        if (parts.length < 4) {
            id = FileIDFactory.getDefault().createFileID(IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL), "scp://unknown");
            file = new URLRemoteFile(0L, 0L, id);
        } else {
            StringBuilder builder = new StringBuilder("scp://");
            int i = 3;
            while (i < parts.length) {
                builder.append(parts[i]);
                if (i > 3 && i < parts.length - 1) {
                    builder.append("|");
                }
                ++i;
            }
            if (parts[0].equals("directory") && !builder.toString().endsWith("/")) {
                builder.append("/");
            } else if (!parts[0].equals("directory") && builder.toString().endsWith("/")) {
                builder.deleteCharAt(builder.length() - 1);
            }
            String originalName = builder.toString();
            String formatedName = originalName.replace(" ", "%20");
            URI uri = new URI(formatedName);
            id = FileIDFactory.getDefault().createFileID(IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL), new Object[]{uri});
            long size = Long.parseLong(parts[1]);
            long modification = Long.parseLong(parts[2]);
            file = new URLRemoteFile(modification, size, id);
        }
        return file;
    }

    protected void cleanUp() {
        super.cleanUp();
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel = null;
        }
        if (this.scpUtil != null) {
            this.scpUtil.dispose();
            this.scpUtil = null;
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.scp", 4, "cleanup", (Throwable)e));
        }
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.scp", 4, "cleanup", (Throwable)e));
        }
        this.inputStream = null;
        this.outputStream = null;
    }

    protected void setupProxy(Proxy proxy) {
        this.proxy = proxy;
        this.setupProxies();
    }

    protected void setInputStream(InputStream ins) {
        this.inputStream = ins;
    }

    protected void setOutputStream(OutputStream outs) {
        this.outputStream = outs;
    }

    public IConnectContext getConnectContext() {
        return this.connectContext;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public URL getTargetURL() {
        return this.directoryOrFile;
    }

    public Map getOptions() {
        return null;
    }
}

