/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.zookeeper.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ecf.core.util.SystemLogService;
import org.eclipse.ecf.provider.zookeeper.DiscoveryActivator;
import org.eclipse.ecf.provider.zookeeper.core.DefaultDiscoveryConfig;
import org.eclipse.ecf.provider.zookeeper.core.ZooDiscoveryContainer;
import org.osgi.service.log.LogService;

public class Logger {
    private static SystemLogService nativeLogger = new SystemLogService("org.eclipse.ecf.provider.zookeeper");
    private static Set<LogService> logServices = new HashSet<LogService>();

    public static void bindLogService(LogService ls) {
        logServices.add(ls);
    }

    public static void unbindLogService(LogService ls) {
        logServices.remove(ls);
    }

    public static void log(int level, String message, Exception e) {
        Logger.nativeLog(level, message, e);
        for (LogService ls : logServices) {
            if (ls == null) {
                Logger.nativeLog(level, message, e);
                continue;
            }
            ls.log(DiscoveryActivator.getContext().getServiceReference(ZooDiscoveryContainer.class.getName()), level, message, (Throwable)e);
        }
    }

    private static void nativeLog(int level, String message, Throwable e) {
        if (DefaultDiscoveryConfig.getConsoleLog()) {
            if (e == null) {
                nativeLogger.log(level, message);
            } else {
                nativeLogger.log(level, message, e);
            }
        }
    }

    public static void log(int level, String message, Throwable t) {
        Logger.nativeLog(level, message, t);
        for (LogService ls : logServices) {
            if (ls == null) continue;
            ls.log(DiscoveryActivator.getContext().getServiceReference(ZooDiscoveryContainer.class.getName()), level, message, t);
        }
    }
}

