/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.eventadmin;

import java.io.IOException;
import java.io.NotSerializableException;
import java.security.Permission;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.BaseSharedObject;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectCreateResponseEvent;
import org.eclipse.ecf.core.sharedobject.events.ISharedObjectMessageEvent;
import org.eclipse.ecf.internal.remoteservice.eventadmin.EventHandlerTracker;
import org.eclipse.ecf.internal.remoteservice.eventadmin.EventHandlerWrapper;
import org.eclipse.ecf.internal.remoteservice.eventadmin.LogTracker;
import org.eclipse.ecf.remoteservice.eventadmin.EventMessage;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceException;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.TopicPermission;
import org.osgi.service.log.LogService;

public class DistributedEventAdmin
extends BaseSharedObject
implements EventAdmin {
    private LogTracker logTracker;
    private LogService log;
    private EventHandlerTracker eventHandlerTracker;
    private EventManager eventManager;
    private static final String SHARED_OBJECT_MESSAGE_METHOD = "__handlePostEventSharedObjectMsg";

    public DistributedEventAdmin(BundleContext context, LogService log) {
        Assert.isNotNull((Object)context);
        if (log == null) {
            this.logTracker = new LogTracker(context, System.out);
            this.log = this.logTracker;
        } else {
            this.logTracker = null;
            this.log = log;
        }
        this.eventHandlerTracker = new EventHandlerTracker(context, log);
    }

    public DistributedEventAdmin(BundleContext context) {
        this(context, null);
    }

    public void start() {
        if (this.logTracker != null) {
            this.logTracker.open();
        }
        ThreadGroup eventGroup = new ThreadGroup("Distributed EventAdmin");
        eventGroup.setDaemon(true);
        this.eventManager = new EventManager("Distributed EventAdmin Async Event Dispatcher Thread", eventGroup);
        this.eventHandlerTracker.open();
    }

    public void stop() {
        this.eventHandlerTracker.close();
        if (this.eventManager != null) {
            this.eventManager.close();
            this.eventManager = null;
        }
        if (this.logTracker != null) {
            this.logTracker.close();
        }
    }

    public void sendEvent(Event event) {
        this.localDispatch(event, false);
    }

    public void postEvent(Event event) {
        Event eventToSend = this.getEventToSend(event);
        if (eventToSend != null) {
            this.sendMessage(eventToSend);
            this.notifyPostSendMessage(eventToSend);
            this.localDispatch(event, true);
        }
    }

    protected void sendMessage(Event eventToSend) {
        ID target = null;
        Object[] messageData = null;
        try {
            target = this.getTarget(eventToSend);
            messageData = this.createMessageDataFromEvent(target, eventToSend);
            this.sendSharedObjectMsgTo(target, SharedObjectMsg.createMsg((String)SHARED_OBJECT_MESSAGE_METHOD, (Object[])messageData));
        }
        catch (IOException e) {
            this.handleSendMessageException("send exception to target=" + target, eventToSend, messageData, e);
        }
    }

    protected Object[] createMessageDataFromEvent(ID target, Event eventToSend) throws NotSerializableException {
        Object[] results = new Object[]{new EventMessage(eventToSend)};
        return results;
    }

    protected Event createEventFromMessageData(ID fromID, Object[] messageData) {
        EventMessage eventMessage = (EventMessage)messageData[0];
        return eventMessage.getEvent();
    }

    protected void handleSendMessageException(String message, Event eventToSend, Object[] messageParams, IOException exception) {
        String exceptionMessage = String.valueOf(message == null ? "" : message) + " eventToSend=" + eventToSend + " messageParams=" + (messageParams == null ? null : Arrays.asList(messageParams));
        this.logError(exceptionMessage, exception);
        throw new ServiceException(exceptionMessage, (Throwable)exception);
    }

    protected ID getTarget(Event eventToSend) {
        return null;
    }

    protected Event getEventToSend(Event event) {
        return event;
    }

    protected void notifyPostSendMessage(Event eventSent) {
    }

    protected Event notifyPreLocalDispatch(Event event) {
        return event;
    }

    protected void notifyPostLocalDispatch(Event event) {
    }

    protected void localDispatch(Event dispatchedEvent, boolean isAsync) {
        Event event;
        EventManager currentManager = this.eventManager;
        if (currentManager == null) {
            return;
        }
        if (dispatchedEvent == null) {
            this.log.log(1, "Null event passed to EventAdmin was ignored.");
        }
        if ((event = this.notifyPreLocalDispatch(dispatchedEvent)) != null) {
            String eventTopic = event.getTopic();
            try {
                SecurityManager sm = System.getSecurityManager();
                if (sm != null) {
                    sm.checkPermission((Permission)new TopicPermission(eventTopic, "publish"));
                }
            }
            catch (SecurityException e) {
                this.logError("Caller bundle does not have TopicPermission to publish topic " + eventTopic, e);
                throw e;
            }
            Set eventHandlerWrappers = this.eventHandlerTracker.getHandlers(eventTopic);
            SecurityManager sm = System.getSecurityManager();
            TopicPermission perm = sm == null ? null : new TopicPermission(eventTopic, "subscribe");
            CopyOnWriteIdentityMap listeners = new CopyOnWriteIdentityMap();
            Iterator iter = eventHandlerWrappers.iterator();
            while (iter.hasNext()) {
                EventHandlerWrapper wrapper = (EventHandlerWrapper)iter.next();
                listeners.put((Object)wrapper, (Object)perm);
            }
            ListenerQueue listenerQueue = new ListenerQueue(currentManager);
            listenerQueue.queueListeners(listeners.entrySet(), (EventDispatcher)this.eventHandlerTracker);
            if (isAsync) {
                listenerQueue.dispatchEventAsynchronous(0, (Object)event);
            } else {
                listenerQueue.dispatchEventSynchronous(0, (Object)event);
            }
            this.notifyPostLocalDispatch(event);
        }
    }

    protected boolean handleSharedObjectMsg(ID fromID, SharedObjectMsg msg) {
        String soMethod = msg.getMethod();
        if (SHARED_OBJECT_MESSAGE_METHOD.equals(soMethod)) {
            try {
                Object[] messageData = msg.getParameters();
                Event receivedEvent = this.createEventFromMessageData(fromID, messageData);
                if (receivedEvent != null) {
                    this.notifyReceivedEvent(fromID, receivedEvent);
                    this.localDispatch(receivedEvent, true);
                }
            }
            catch (Exception e) {
                this.logError("DistributedEventAdmin handleSharedObjectMsg error receiving msg=" + msg, e);
            }
            return true;
        }
        this.logError("DistributedEventAdmin received bad shared object msg=" + msg + " from=" + fromID);
        return false;
    }

    protected void notifyReceivedEvent(ID fromID, Event receivedEvent) {
    }

    protected final boolean handleSharedObjectMsgEvent(ISharedObjectMessageEvent event) {
        boolean result = false;
        if (event instanceof ISharedObjectCreateResponseEvent) {
            result = this.handleSharedObjectCreateResponseEvent((ISharedObjectCreateResponseEvent)event);
        } else {
            SharedObjectMsg msg = this.getSharedObjectMsgFromEvent(event);
            if (msg != null) {
                result = this.handleSharedObjectMsg(event.getRemoteContainerID(), msg);
            }
        }
        return result;
    }

    protected void logWarning(String message) {
        this.logWarning(message, null);
    }

    protected void logWarning(String message, Throwable exception) {
        if (this.log != null) {
            this.log.log(2, message, exception);
        } else {
            System.out.println(message);
            if (exception != null) {
                exception.printStackTrace(System.out);
            }
        }
    }

    protected void logError(String message) {
        this.logError(message, null);
    }

    protected void logError(String message, Throwable exception) {
        if (this.log != null) {
            this.log.log(1, message, exception);
        } else {
            System.err.println(message);
            if (exception != null) {
                exception.printStackTrace(System.err);
            }
        }
    }
}

