/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.jmdns.identity;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDCreateException;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.discovery.identity.IServiceTypeID;
import org.eclipse.ecf.provider.jmdns.identity.JMDNSServiceID;
import org.eclipse.ecf.provider.jmdns.identity.JMDNSServiceTypeID;

public class JMDNSNamespace
extends Namespace {
    private static final long serialVersionUID = -7220857203720337921L;
    public static final String JMDNS_SCHEME = "jmdns";
    public static final String NAME = "ecf.namespace.jmdns";
    static /* synthetic */ Class class$0;

    private String getInitFromExternalForm(Object[] args) {
        String arg;
        if (args == null || args.length < 1 || args[0] == null) {
            return null;
        }
        if (args[0] instanceof String && (arg = (String)args[0]).startsWith(String.valueOf(this.getScheme()) + ":")) {
            int index = arg.indexOf(":");
            if (index >= arg.length()) {
                return null;
            }
            return arg.substring(index + 1);
        }
        return null;
    }

    public ID createInstance(Object[] parameters) {
        String type;
        block11: {
            type = null;
            try {
                String init = this.getInitFromExternalForm(parameters);
                if (init != null) {
                    type = init;
                    break block11;
                }
                if (parameters == null || parameters.length < 1 || parameters.length > 2) {
                    throw new IDCreateException("Parameters cannot be null and must be of length 1 or 2");
                }
                if (parameters[0] instanceof IServiceTypeID) {
                    type = ((IServiceTypeID)parameters[0]).getName();
                    break block11;
                }
                if (parameters[0] instanceof String) {
                    type = (String)parameters[0];
                    break block11;
                }
                throw new IDCreateException("Service type id parameter has to be of type String or IServiceTypeID");
            }
            catch (Exception e) {
                throw new IDCreateException(String.valueOf(this.getName()) + " createInstance()", (Throwable)e);
            }
        }
        JMDNSServiceTypeID stid = new JMDNSServiceTypeID(this, type);
        if (parameters.length == 1) {
            return stid;
        }
        if (parameters[1] instanceof String) {
            try {
                URI uri = new URI((String)parameters[1]);
                return new JMDNSServiceID(this, (IServiceTypeID)stid, uri);
            }
            catch (URISyntaxException e) {
                throw new IDCreateException("Second parameter as String must follow URI syntax");
            }
        }
        if (parameters[1] instanceof URI) {
            return new JMDNSServiceID(this, (IServiceTypeID)stid, (URI)parameters[1]);
        }
        throw new IDCreateException("Second parameter must be of either String or URI type");
    }

    public String getScheme() {
        return JMDNS_SCHEME;
    }

    public Class[][] getSupportedParameterTypes() {
        Class[][] classArray = new Class[2][];
        Class[] classArray2 = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz;
        classArray[0] = classArray2;
        Class[] classArray3 = new Class[2];
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[0] = clazz2;
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray3[1] = clazz3;
        classArray[1] = classArray3;
        return classArray;
    }
}

