/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.dnssd;

import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.ecf.core.ContainerConnectException;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryContainerAdapter;
import org.eclipse.ecf.provider.dnssd.DnsSdServiceTypeID;
import org.eclipse.ecf.provider.dnssd.IDnsSdDiscoveryConstants;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class Activator
implements BundleActivator {
    public static final String PLUGIN_ID = "org.eclipse.ecf.provider.dnssd";
    public static final String DISCOVERY_CONTAINER_NAME_VALUE = "ecf.discovery.dnssd";
    public static final String LOCATOR = ".locator";
    public static final String ADVERTISER = ".advertiser";
    private static final String DISCOVERY_CONTAINER_NAME_KEY = "org.eclipse.ecf.discovery.containerName";
    private final Map serviceRegistrations = new HashMap();
    private volatile BundleContext context;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public void start(BundleContext context) throws Exception {
        this.context = context;
        Properties locCmProps = new Properties();
        locCmProps.put("service.pid", "ecf.discovery.dnssd.locator");
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(string, (Object)new DnsSdManagedServiceFactory(clazz2), (Dictionary)locCmProps);
        Properties locProps = new Properties();
        locProps.put(DISCOVERY_CONTAINER_NAME_KEY, "ecf.discovery.dnssd.locator");
        locProps.put("service.ranking", new Integer(750));
        Class<?> clazz3 = class$0;
        if (clazz3 == null) {
            try {
                clazz3 = class$0 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string2 = clazz3.getName();
        Class<?> clazz4 = class$2;
        if (clazz4 == null) {
            try {
                clazz4 = class$2 = Class.forName("org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryLocator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.serviceRegistrations.put(null, context.registerService(string2, (Object)new DnsSdServiceFactory(clazz4), (Dictionary)locProps));
        Properties advCmProps = new Properties();
        advCmProps.put("service.pid", "ecf.discovery.dnssd.advertiser");
        Class<?> clazz5 = class$1;
        if (clazz5 == null) {
            try {
                clazz5 = class$1 = Class.forName("org.osgi.service.cm.ManagedServiceFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string3 = clazz5.getName();
        Class<?> clazz6 = class$3;
        if (clazz6 == null) {
            try {
                clazz6 = class$3 = Class.forName("org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryAdvertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        context.registerService(string3, (Object)new DnsSdManagedServiceFactory(clazz6), (Dictionary)advCmProps);
        Properties advProps = new Properties();
        advProps.put(DISCOVERY_CONTAINER_NAME_KEY, "ecf.discovery.dnssd.advertiser");
        advProps.put("service.ranking", new Integer(750));
        Class<?> clazz7 = class$4;
        if (clazz7 == null) {
            try {
                clazz7 = class$4 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryAdvertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String string4 = clazz7.getName();
        Class<?> clazz8 = class$3;
        if (clazz8 == null) {
            try {
                clazz8 = class$3 = Class.forName("org.eclipse.ecf.provider.dnssd.DnsSdDiscoveryAdvertiser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.serviceRegistrations.put(null, context.registerService(string4, (Object)new DnsSdServiceFactory(clazz8), (Dictionary)advProps));
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serviceRegistrations != null) {
            Iterator itr = this.serviceRegistrations.values().iterator();
            while (itr.hasNext()) {
                ServiceRegistration serviceRegistration = (ServiceRegistration)itr.next();
                this.disposeServiceRegistration(serviceRegistration);
            }
        }
        this.context = null;
    }

    private void disposeServiceRegistration(ServiceRegistration serviceRegistration) {
        ServiceReference reference = serviceRegistration.getReference();
        DnsSdDiscoveryContainerAdapter aContainer = (DnsSdDiscoveryContainerAdapter)((Object)this.context.getService(reference));
        serviceRegistration.unregister();
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.ecf.core.IContainer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IContainer container = (IContainer)aContainer.getAdapter(clazz);
        container.dispose();
        container.disconnect();
    }

    private class DnsSdManagedServiceFactory
    implements ManagedServiceFactory {
        private final Class containerClass;

        public DnsSdManagedServiceFactory(Class aContainerClass) {
            this.containerClass = aContainerClass;
        }

        public String getName() {
            return this.getClass().getName();
        }

        public void updated(String pid, Dictionary properties) throws ConfigurationException {
            block14: {
                if (properties != null) {
                    DnsSdDiscoveryContainerAdapter adapter = null;
                    DnsSdServiceTypeID targetID = null;
                    try {
                        String tsigKey;
                        String resolver;
                        ServiceRegistration serviceRegistration = (ServiceRegistration)Activator.this.serviceRegistrations.get(pid);
                        if (serviceRegistration != null) {
                            adapter = (DnsSdDiscoveryContainerAdapter)((Object)Activator.this.context.getService(serviceRegistration.getReference()));
                            targetID = (DnsSdServiceTypeID)adapter.getConnectedID();
                        } else {
                            adapter = (DnsSdDiscoveryContainerAdapter)((Object)this.containerClass.newInstance());
                            targetID = new DnsSdServiceTypeID();
                        }
                        String[] searchPaths = (String[])properties.get("searchPath");
                        if (searchPaths != null) {
                            targetID.setSearchPath(searchPaths);
                        }
                        if ((resolver = (String)properties.get("resolver")) != null) {
                            adapter.setResolver(resolver);
                        }
                        if ((tsigKey = (String)properties.get("tsig-key")) != null) {
                            String tsigKeyName = (String)properties.get(IDnsSdDiscoveryConstants.CA_TSIG_KEY_NAME);
                            adapter.setTsigKey(tsigKeyName, tsigKey);
                        }
                        if (serviceRegistration != null) break block14;
                        Properties props = new Properties();
                        props.put("service.pid", pid);
                        adapter.connect((ID)targetID, null);
                        Map map = Activator.this.serviceRegistrations;
                        BundleContext bundleContext = Activator.this.context;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.ecf.discovery.IDiscoveryLocator");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        map.put(pid, bundleContext.registerService(clazz.getName(), (Object)adapter, (Dictionary)props));
                    }
                    catch (ContainerConnectException e) {
                        throw new ConfigurationException("IDnsSdDiscoveryConstants properties", e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (ClassCastException cce) {
                        throw new ConfigurationException("IDnsSdDiscoveryConstants properties", cce.getLocalizedMessage(), (Throwable)cce);
                    }
                    catch (InstantiationException e) {
                        throw new ConfigurationException("InstantiationException", e.getLocalizedMessage(), (Throwable)e);
                    }
                    catch (IllegalAccessException e) {
                        throw new ConfigurationException("IllegalAccessException", e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }

        public void deleted(String pid) {
            ServiceRegistration serviceRegistration = (ServiceRegistration)Activator.this.serviceRegistrations.get(pid);
            Activator.this.disposeServiceRegistration(serviceRegistration);
        }
    }

    public class DnsSdServiceFactory
    implements ServiceFactory {
        private volatile DnsSdDiscoveryContainerAdapter container;
        private final Class containerClass;

        public DnsSdServiceFactory(Class aDiscoveryContainerClass) {
            this.containerClass = aDiscoveryContainerClass;
        }

        public Object getService(Bundle bundle, ServiceRegistration registration) {
            if (this.container == null) {
                try {
                    this.container = (DnsSdDiscoveryContainerAdapter)((Object)this.containerClass.newInstance());
                    this.container.connect(null, null);
                }
                catch (ContainerConnectException e) {
                    e.printStackTrace();
                    this.container = null;
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                    this.container = null;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    this.container = null;
                }
            }
            return this.container;
        }

        public void ungetService(Bundle bundle, ServiceRegistration registration, Object service) {
        }
    }
}

